/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import voltaic.api.creativetab.CreativeTabSupplier;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.api.radiation.util.IRadiationRecipient;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.common.settings.VoltaicConstants;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class ItemVoltaic
extends Item
implements CreativeTabSupplier {
    private final Supplier<CreativeModeTab> creativeTab;

    public ItemVoltaic(Item.Properties properties, Supplier<CreativeModeTab> creativeTab) {
        super(properties);
        this.creativeTab = creativeTab;
    }

    @Override
    public void addCreativeModeItems(CreativeModeTab tab, List<ItemStack> items) {
        items.add(new ItemStack((ItemLike)this));
    }

    @Override
    public boolean isAllowedInCreativeTab(CreativeModeTab tab) {
        return this.creativeTab.get() == tab;
    }

    @Override
    public boolean hasCreativeTab() {
        return this.creativeTab != null;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        super.onEntityItemUpdate(stack, entity);
        Level world = entity.m_9236_();
        if (world.f_46443_ || !VoltaicConstants.RADIATION_SYSTEM_ENABLED) {
            return super.onEntityItemUpdate(stack, entity);
        }
        RadioactiveObject rad = RadioactiveItemRegister.getValue(stack.m_41720_());
        double amount = (double)stack.m_41613_() * rad.amount();
        int range = (int)(Math.sqrt(amount) / (5.0 * Math.sqrt(2.0)) * 1.25);
        RadiationSystem.addRadiationSource(world, new SimpleRadiationSource(amount, rad.strength(), range, true, 0, entity.m_20097_().m_7494_(), false, false));
        return super.onEntityItemUpdate(stack, entity);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (world.f_46443_ || !VoltaicConstants.RADIATION_SYSTEM_ENABLED) {
            return;
        }
        RadioactiveObject rad = RadioactiveItemRegister.getValue(stack.m_41720_());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!world.f_46443_) {
                IRadiationRecipient cap = (IRadiationRecipient)living.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT).orElse((Object)CapabilityUtils.EMPTY_RADIATION_REPIPIENT);
                if (cap == CapabilityUtils.EMPTY_RADIATION_REPIPIENT) {
                    return;
                }
                cap.recieveRadiation(living, (double)stack.m_41613_() * rad.amount(), rad.strength());
            }
        }
    }
}

