/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.packet.types.client;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.packet.types.client.ClientBarrierMethods;

public class PacketSetClientRadioactiveGases {
    public static final StreamCodec<FriendlyByteBuf, PacketSetClientRadioactiveGases> CODEC = new StreamCodec<FriendlyByteBuf, PacketSetClientRadioactiveGases>(){

        @Override
        public PacketSetClientRadioactiveGases decode(FriendlyByteBuf buf) {
            int count = buf.readInt();
            HashMap<Gas, RadioactiveObject> values = new HashMap<Gas, RadioactiveObject>();
            for (int i = 0; i < count; ++i) {
                values.put(GasStack.STREAM_CODEC.decode(buf).getGas(), RadioactiveObject.STREAM_CODEC.decode((ByteBuf)buf));
            }
            return new PacketSetClientRadioactiveGases(values);
        }

        @Override
        public void encode(FriendlyByteBuf buf, PacketSetClientRadioactiveGases packet) {
            buf.writeInt(packet.gases.size());
            for (Map.Entry<Gas, RadioactiveObject> entry : packet.gases.entrySet()) {
                GasStack.STREAM_CODEC.encode(buf, new GasStack(entry.getKey(), 1, 293, 1));
                RadioactiveObject.STREAM_CODEC.encode((ByteBuf)buf, entry.getValue());
            }
        }
    };
    private final HashMap<Gas, RadioactiveObject> gases;

    public PacketSetClientRadioactiveGases(HashMap<Gas, RadioactiveObject> items) {
        this.gases = items;
    }

    public static void handle(PacketSetClientRadioactiveGases message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handleSetClientRadioactiveGases(message.gases));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetClientRadioactiveGases message, FriendlyByteBuf buf) {
        CODEC.encode(buf, message);
    }

    public static PacketSetClientRadioactiveGases decode(FriendlyByteBuf buf) {
        return CODEC.decode(buf);
    }
}

