/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.packet.types.client;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;
import voltaic.common.packet.types.client.ClientBarrierMethods;

public class PacketUpdateCariedItemClient {
    public static final StreamCodec<FriendlyByteBuf, PacketUpdateCariedItemClient> CODEC = new StreamCodec<FriendlyByteBuf, PacketUpdateCariedItemClient>(){

        @Override
        public void encode(FriendlyByteBuf buffer, PacketUpdateCariedItemClient value) {
            StreamCodec.ITEM_STACK.encode(buffer, value.carriedItem);
            StreamCodec.BLOCK_POS.encode((ByteBuf)buffer, value.tilePos);
            StreamCodec.UUID.encode((ByteBuf)buffer, value.playerId);
        }

        @Override
        public PacketUpdateCariedItemClient decode(FriendlyByteBuf buffer) {
            return new PacketUpdateCariedItemClient(StreamCodec.ITEM_STACK.decode(buffer), StreamCodec.BLOCK_POS.decode((ByteBuf)buffer), StreamCodec.UUID.decode((ByteBuf)buffer));
        }
    };
    private final ItemStack carriedItem;
    private final BlockPos tilePos;
    private final UUID playerId;

    public PacketUpdateCariedItemClient(ItemStack carriedItem, BlockPos tilePos, UUID playerId) {
        this.carriedItem = carriedItem;
        this.tilePos = tilePos;
        this.playerId = playerId;
    }

    public static void handle(PacketUpdateCariedItemClient message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handleUpdateCarriedItemClient(message.carriedItem, message.tilePos, message.playerId));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketUpdateCariedItemClient message, FriendlyByteBuf buf) {
        CODEC.encode(buf, message);
    }

    public static PacketUpdateCariedItemClient decode(FriendlyByteBuf buf) {
        return CODEC.decode(buf);
    }
}

