/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.GasIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.tile.components.type.ComponentProcessor;

public abstract class VoltaicRecipe
implements Recipe<RecipeWrapper> {
    private final ResourceLocation group;
    private final double xp;
    private final int ticks;
    private final double usagePerTick;
    private final List<ProbableItem> itemBiproducts;
    private final List<ProbableFluid> fluidBiproducts;
    private final List<ProbableGas> gasBiproducts;
    private final HashMap<Integer, List<Integer>> itemArrangements = new HashMap();
    @Nullable
    private List<Integer> fluidArrangement;
    @Nullable
    private List<Integer> gasArrangement;

    public VoltaicRecipe(ResourceLocation recipeGroup, double experience, int ticks, double usagePerTick, List<ProbableItem> itemBiproducts, List<ProbableFluid> fluidBiproducts, List<ProbableGas> gasBiproducts) {
        this.group = recipeGroup;
        this.xp = experience;
        this.ticks = ticks;
        this.usagePerTick = usagePerTick;
        this.itemBiproducts = itemBiproducts;
        this.fluidBiproducts = fluidBiproducts;
        this.gasBiproducts = gasBiproducts;
    }

    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        return false;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.group;
    }

    public boolean hasItemBiproducts() {
        return this.itemBiproducts.size() != 0;
    }

    public boolean hasFluidBiproducts() {
        return this.fluidBiproducts.size() != 0;
    }

    public boolean hasGasBiproducts() {
        return this.gasBiproducts.size() != 0;
    }

    @Nullable
    public List<ProbableItem> getItemBiproducts() {
        return this.itemBiproducts;
    }

    @Nullable
    public List<ProbableFluid> getFluidBiproducts() {
        return this.fluidBiproducts;
    }

    @Nullable
    public List<ProbableGas> getGasBiproducts() {
        return this.gasBiproducts;
    }

    public ItemStack[] getFullItemBiStacks() {
        ItemStack[] items = new ItemStack[this.getItemBiproductCount()];
        for (int i = 0; i < this.getItemBiproductCount(); ++i) {
            items[i] = this.itemBiproducts.get(i).getFullStack();
        }
        return items;
    }

    public FluidStack[] getFullFluidBiStacks() {
        FluidStack[] fluids = new FluidStack[this.getFluidBiproductCount()];
        for (int i = 0; i < this.getFluidBiproductCount(); ++i) {
            fluids[i] = this.fluidBiproducts.get(i).getFullStack();
        }
        return fluids;
    }

    public GasStack[] getFullGasBiStacks() {
        GasStack[] gases = new GasStack[this.getGasBiproductCount()];
        for (int i = 0; i < this.getGasBiproductCount(); ++i) {
            gases[i] = this.gasBiproducts.get(i).getFullStack();
        }
        return gases;
    }

    public int getItemBiproductCount() {
        return this.itemBiproducts.size();
    }

    public int getFluidBiproductCount() {
        return this.fluidBiproducts.size();
    }

    public int getGasBiproductCount() {
        return this.gasBiproducts.size();
    }

    public double getXp() {
        return this.xp;
    }

    public int getTicks() {
        return this.ticks;
    }

    public double getUsagePerTick() {
        return this.usagePerTick;
    }

    public void setItemArrangement(Integer procNumber, List<Integer> arrangement) {
        this.itemArrangements.put(procNumber, arrangement);
    }

    public List<Integer> getItemArrangment(Integer procNumber) {
        return this.itemArrangements.get(procNumber);
    }

    public void setFluidArrangement(List<Integer> arrangement) {
        this.fluidArrangement = arrangement;
    }

    public List<Integer> getFluidArrangement() {
        return this.fluidArrangement;
    }

    public void setGasArrangement(List<Integer> arrangement) {
        this.gasArrangement = arrangement;
    }

    public List<Integer> getGasArrangement() {
        return this.gasArrangement;
    }

    public static List<VoltaicRecipe> findRecipesbyType(RecipeType<? extends VoltaicRecipe> typeIn, Level world) {
        return world != null ? world.m_7465_().m_44013_(typeIn) : Collections.emptyList();
    }

    @Nullable
    public static VoltaicRecipe getRecipe(ComponentProcessor pr, List<VoltaicRecipe> cachedRecipes, int index) {
        for (VoltaicRecipe recipe : cachedRecipes) {
            if (!recipe.matchesRecipe(pr, index)) continue;
            return recipe;
        }
        return null;
    }

    public static Pair<List<Integer>, Boolean> areItemsValid(List<CountableIngredient> ingredients, List<ItemStack> stacks) {
        Boolean valid = true;
        ArrayList<Integer> slotOreintation = new ArrayList<Integer>();
        for (int i = 0; i < ingredients.size(); ++i) {
            CountableIngredient ing = ingredients.get(i);
            int slotNum = -1;
            for (int j = 0; j < stacks.size(); ++j) {
                if (!ing.test(stacks.get(j))) continue;
                slotNum = j;
                break;
            }
            if (slotNum <= -1 || slotOreintation.contains(slotNum)) continue;
            slotOreintation.add(slotNum);
        }
        if (slotOreintation.size() < ingredients.size()) {
            valid = false;
        }
        return Pair.of(slotOreintation, (Object)valid);
    }

    public static Pair<List<Integer>, Boolean> areFluidsValid(List<FluidIngredient> ingredients, FluidTank[] fluidTanks) {
        Boolean valid = true;
        ArrayList<Integer> tankOrientation = new ArrayList<Integer>();
        for (int i = 0; i < ingredients.size(); ++i) {
            FluidIngredient ing = ingredients.get(i);
            int tankNum = -1;
            for (int j = 0; j < fluidTanks.length; ++j) {
                if (!ing.testFluid(fluidTanks[j].getFluid())) continue;
                tankNum = j;
                break;
            }
            if (tankNum <= -1 || tankOrientation.contains(tankNum)) continue;
            tankOrientation.add(tankNum);
        }
        if (tankOrientation.size() < ingredients.size()) {
            valid = false;
        }
        return Pair.of(tankOrientation, (Object)valid);
    }

    public static Pair<List<Integer>, Boolean> areGasesValid(List<GasIngredient> ingredients, GasTank[] gasTanks) {
        Boolean valid = true;
        ArrayList<Integer> tankOrientation = new ArrayList<Integer>();
        for (int i = 0; i < ingredients.size(); ++i) {
            GasIngredient ing = ingredients.get(i);
            int tankNum = -1;
            for (int j = 0; j < gasTanks.length; ++j) {
                if (!ing.testGas(gasTanks[j].getGas(), true, true)) continue;
                tankNum = j;
                break;
            }
            if (tankNum <= -1 || tankOrientation.contains(tankNum)) continue;
            tankOrientation.add(tankNum);
        }
        if (tankOrientation.size() < ingredients.size()) {
            valid = false;
        }
        return Pair.of(tankOrientation, (Object)valid);
    }

    public abstract boolean matchesRecipe(ComponentProcessor var1, int var2);

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122779_();
    }
}

