/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.recipeutils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.codec.StreamCodec;

public class FluidIngredient
extends Ingredient {
    public static final Codec<FluidIngredient> CODEC_DIRECT_FLUID = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(instance0 -> instance0.fluid), (App)Codec.INT.fieldOf("amount").forGetter(instance0 -> instance0.amount)).apply((Applicative)instance, (fluid, amount) -> new FluidIngredient((Fluid)fluid, (int)amount)));
    public static final Codec<FluidIngredient> CODEC_TAGGED_FLUID = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256808_).fieldOf("tag").forGetter(instance0 -> instance0.tag), (App)Codec.INT.fieldOf("amount").forGetter(instance0 -> instance0.amount)).apply((Applicative)instance, (tag, amount) -> new FluidIngredient((TagKey<Fluid>)tag, (int)amount)));
    public static final Codec<FluidIngredient> CODEC = Codec.either(CODEC_TAGGED_FLUID, CODEC_DIRECT_FLUID).xmap(either -> (FluidIngredient)((Object)((Object)either.map(tag -> tag, fluid -> fluid))), value -> {
        if (value.tag != null) {
            return Either.left((Object)value);
        }
        if (value.fluid != null) {
            return Either.right((Object)value);
        }
        throw new UnsupportedOperationException("The Fluid Ingredient neither has a tag nor a direct fluid value defined!");
    });
    public static final Codec<List<FluidIngredient>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<FriendlyByteBuf, FluidIngredient> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, FluidIngredient>(){

        @Override
        public void encode(FriendlyByteBuf buf, FluidIngredient ing) {
            List<FluidStack> fluidStacks = ing.getMatchingFluids();
            buf.writeInt(fluidStacks.size());
            for (FluidStack stack : fluidStacks) {
                StreamCodec.FLUID_STACK.encode(buf, stack);
            }
        }

        @Override
        public FluidIngredient decode(FriendlyByteBuf buf) {
            ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                stacks.add(StreamCodec.FLUID_STACK.decode(buf));
            }
            return new FluidIngredient(stacks);
        }
    };
    public static final StreamCodec<FriendlyByteBuf, List<FluidIngredient>> LIST_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, List<FluidIngredient>>(){

        @Override
        public void encode(FriendlyByteBuf buf, List<FluidIngredient> ings) {
            buf.writeInt(ings.size());
            for (FluidIngredient ing : ings) {
                STREAM_CODEC.encode(buf, ing);
            }
        }

        @Override
        public List<FluidIngredient> decode(FriendlyByteBuf buf) {
            int length = buf.readInt();
            ArrayList<FluidIngredient> ings = new ArrayList<FluidIngredient>();
            for (int i = 0; i < length; ++i) {
                ings.add(STREAM_CODEC.decode(buf));
            }
            return ings;
        }
    };
    @Nonnull
    private List<FluidStack> fluidStacks;
    @Nullable
    public TagKey<Fluid> tag;
    @Nullable
    private Fluid fluid;
    private int amount;

    public FluidIngredient(FluidStack fluidStack) {
        super(Stream.empty());
        this.fluid = fluidStack.getFluid();
        this.amount = fluidStack.getAmount();
    }

    public FluidIngredient(Fluid fluid, int amount) {
        this(new FluidStack(fluid, amount));
    }

    public FluidIngredient(List<FluidStack> fluidStack) {
        super(Stream.empty());
        this.fluidStacks = fluidStack;
        FluidStack fluid = this.getFluidStack();
        this.fluid = fluid.getFluid();
        this.amount = fluid.getAmount();
    }

    public FluidIngredient(TagKey<Fluid> tag, int amount) {
        super(Stream.empty());
        this.tag = tag;
        this.amount = amount;
    }

    public boolean test(ItemStack stack) {
        return false;
    }

    public ItemStack[] m_43908_() {
        return new ItemStack[0];
    }

    public boolean isSimple() {
        return false;
    }

    public boolean testFluid(@Nullable FluidStack t) {
        if (t == null || t.isEmpty()) {
            return false;
        }
        for (FluidStack stack : this.getMatchingFluids()) {
            if (t.getAmount() < stack.getAmount() || !t.getFluid().m_6212_(stack.getFluid())) continue;
            return true;
        }
        return false;
    }

    public List<FluidStack> getMatchingFluids() {
        if (this.fluidStacks == null) {
            this.fluidStacks = new ArrayList<FluidStack>();
            if (this.tag != null) {
                ((HolderSet.Named)BuiltInRegistries.f_257020_.m_203431_(this.tag).get()).forEach(h -> this.fluidStacks.add(new FluidStack((Fluid)h.get(), this.amount)));
            } else if (this.fluid != null) {
                this.fluidStacks.add(new FluidStack(this.fluid, this.amount));
            } else {
                throw new UnsupportedOperationException("Fluid Ingredient has neither a fluid nor a fluid tag defined");
            }
        }
        return this.fluidStacks;
    }

    public FluidStack getFluidStack() {
        return this.getMatchingFluids().size() < 1 ? FluidStack.EMPTY : this.getMatchingFluids().get(0);
    }

    public String toString() {
        return "Fluid : " + this.getFluidStack().getFluid().toString() + ", Amt : " + this.amount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluidIngredient) {
            FluidIngredient ing = (FluidIngredient)((Object)obj);
            return ing.getMatchingFluids().equals(this.getMatchingFluids()) && ing.amount == this.amount;
        }
        return false;
    }
}

