/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.advancement;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.extensions.IForgeAdvancementBuilder;

public class AdvancementBuilder
implements IForgeAdvancementBuilder {
    public final ResourceLocation id;
    @Nullable
    private ResourceLocation parentId;
    @Nullable
    private Advancement parent;
    @Nullable
    private DisplayInfo display;
    private AdvancementRewards rewards = AdvancementRewards.f_9978_;
    private Map<String, Criterion> criteria = Maps.newLinkedHashMap();
    @Nullable
    private String[][] requirements;
    private RequirementsStrategy requirementsStrategy = RequirementsStrategy.f_15978_;
    @Nullable
    private String comment;
    @Nullable
    private String author;
    @Nullable
    private List<ICondition> conditions;

    private AdvancementBuilder(ResourceLocation id) {
        this.id = id;
    }

    public static AdvancementBuilder create(ResourceLocation id) {
        return new AdvancementBuilder(id);
    }

    public AdvancementBuilder parent(Advancement parent) {
        this.parent = parent;
        return this;
    }

    public AdvancementBuilder parent(ResourceLocation parentId) {
        this.parentId = parentId;
        return this;
    }

    public AdvancementBuilder display(Item item, Component title, Component description, AdvancementBackgrounds background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return this.display(new DisplayInfo(new ItemStack((ItemLike)item), title, description, background.loc, frame, showToast, announceToChat, hidden));
    }

    public AdvancementBuilder display(ItemStack stack, Component title, Component description, AdvancementBackgrounds background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return this.display(new DisplayInfo(stack, title, description, background.loc, frame, showToast, announceToChat, hidden));
    }

    public AdvancementBuilder display(ItemStack stack, Component title, Component description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return this.display(new DisplayInfo(stack, title, description, background, frame, showToast, announceToChat, hidden));
    }

    public AdvancementBuilder display(ItemLike item, Component title, Component description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return this.display(new DisplayInfo(new ItemStack((ItemLike)item.m_5456_()), title, description, background, frame, showToast, announceToChat, hidden));
    }

    public AdvancementBuilder display(DisplayInfo display) {
        this.display = display;
        return this;
    }

    public AdvancementBuilder rewards(AdvancementRewards.Builder rewardsBuilder) {
        return this.rewards(rewardsBuilder.m_10004_());
    }

    public AdvancementBuilder rewards(AdvancementRewards rewards) {
        this.rewards = rewards;
        return this;
    }

    public AdvancementBuilder addCriterion(String key, CriterionTriggerInstance criterion) {
        return this.addCriterion(key, new Criterion(criterion));
    }

    public AdvancementBuilder addCriterion(String key, Criterion criterion) {
        if (this.criteria.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate criterion " + key);
        }
        this.criteria.put(key, criterion);
        return this;
    }

    public AdvancementBuilder requirements(RequirementsStrategy strategy) {
        this.requirementsStrategy = strategy;
        return this;
    }

    public AdvancementBuilder requirements(String[][] requirements) {
        this.requirements = requirements;
        return this;
    }

    public AdvancementBuilder condition(ICondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ICondition>();
        }
        this.conditions.add(condition);
        return this;
    }

    public AdvancementBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public AdvancementBuilder author(String author) {
        this.author = author;
        return this;
    }

    public boolean canBuild(Function<ResourceLocation, Advancement> parentLookup) {
        if (this.parentId == null) {
            return true;
        }
        if (this.parent == null) {
            this.parent = parentLookup.apply(this.parentId);
        }
        return this.parent != null;
    }

    public Advancement build() {
        if (!this.canBuild(resourceLocation -> null)) {
            throw new IllegalStateException("Tried to build incomplete advancement!");
        }
        if (this.requirements == null) {
            this.requirements = this.requirementsStrategy.m_15985_(this.criteria.keySet());
        }
        return new Advancement(this.id, this.parent, this.display, this.rewards, this.criteria, this.requirements, false);
    }

    public Advancement save(Consumer<Advancement> consumer) {
        Advancement adv = this.build();
        consumer.accept(adv);
        return adv;
    }

    public JsonObject serializeToJson() {
        if (this.requirements == null) {
            this.requirements = this.requirementsStrategy.m_15985_(this.criteria.keySet());
        }
        JsonObject jsonobject = new JsonObject();
        if (this.author != null) {
            jsonobject.addProperty("__author", this.author);
        }
        if (this.comment != null) {
            jsonobject.addProperty("__comment", this.comment);
        }
        if (this.parent != null) {
            jsonobject.addProperty("parent", this.parent.m_138327_().toString());
        } else if (this.parentId != null) {
            jsonobject.addProperty("parent", this.parentId.toString());
        }
        if (this.display != null) {
            jsonobject.add("display", this.display.m_14998_());
        }
        jsonobject.add("rewards", this.rewards.m_9997_());
        JsonObject jsonobject1 = new JsonObject();
        for (Map.Entry<String, Criterion> entry : this.criteria.entrySet()) {
            jsonobject1.add(entry.getKey(), entry.getValue().m_11425_());
        }
        jsonobject.add("criteria", (JsonElement)jsonobject1);
        JsonArray jsonarray1 = new JsonArray();
        for (String[] astring : this.requirements) {
            JsonArray jsonarray = new JsonArray();
            for (String s : astring) {
                jsonarray.add(s);
            }
            jsonarray1.add((JsonElement)jsonarray);
        }
        jsonobject.add("requirements", (JsonElement)jsonarray1);
        if (this.conditions != null) {
            JsonArray jsonArray = new JsonArray();
            for (ICondition c : this.conditions) {
                jsonArray.add((JsonElement)CraftingHelper.serialize((ICondition)c));
            }
            jsonobject.add("conditions", (JsonElement)jsonArray);
        }
        return jsonobject;
    }

    public static enum AdvancementBackgrounds {
        NONE(null),
        ADVENTURE(new ResourceLocation("textures/gui/advancements/backgrounds/adventure.png")),
        END(new ResourceLocation("textures/gui/advancements/backgrounds/end.png")),
        HUSBANDRY(new ResourceLocation("textures/gui/advancements/backgrounds/husbandry.png")),
        NETHER(new ResourceLocation("textures/gui/advancements/backgrounds/nether.png")),
        STONE(new ResourceLocation("textures/gui/advancements/backgrounds/stone.png"));

        public final ResourceLocation loc;

        private AdvancementBackgrounds(ResourceLocation loc) {
            this.loc = loc;
        }
    }
}

