/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.recipe;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CustomCookingRecipe
implements FinishedRecipe {
    private final ResourceLocation id;
    private final CookingBookCategory category;
    private final Ingredient ingredient;
    private final Item result;
    private final float experience;
    private final int cookingTime;
    private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

    private CustomCookingRecipe(ResourceLocation id, Ingredient input, Item result, float experience, int cookingTime, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
        this.id = id;
        this.category = CookingBookCategory.MISC;
        this.ingredient = input;
        this.result = result;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.serializer = serializer;
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    public void m_7917_(JsonObject pJson) {
        pJson.addProperty("category", this.category.m_7912_());
        pJson.add("ingredient", this.ingredient.m_43942_());
        pJson.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
        pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
        pJson.addProperty("cookingtime", (Number)this.cookingTime);
    }

    public ResourceLocation m_6445_() {
        return this.id;
    }

    public RecipeSerializer<?> m_6637_() {
        return this.serializer;
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }

    public static SmeltingBuilder smeltingRecipe(Item result, float experience, int smeltTime) {
        return new SmeltingBuilder(result, experience, smeltTime);
    }

    public static SmokingBuilder smokingRecipe(Item result, float experience, int smeltTime) {
        return new SmokingBuilder(result, experience, smeltTime);
    }

    public static BlastingBuilder blastingRecipe(Item result, float experience, int smeltTime) {
        return new BlastingBuilder(result, experience, smeltTime);
    }

    public static class SmeltingBuilder
    extends Builder {
        private SmeltingBuilder(Item result, float experience, int smeltTime) {
            super(result, experience, smeltTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_);
        }
    }

    public static class SmokingBuilder
    extends Builder {
        private SmokingBuilder(Item result, float experience, int smeltTime) {
            super(result, experience, smeltTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44093_);
        }
    }

    public static class BlastingBuilder
    extends Builder {
        private BlastingBuilder(Item result, float experience, int smeltTime) {
            super(result, experience, smeltTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_);
        }
    }

    public static class Builder {
        private final Item result;
        private final float experience;
        private final int smeltTime;
        private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;
        private Ingredient input;

        private Builder(Item result, float experience, int smeltTime, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
            this.result = result;
            this.experience = experience;
            this.smeltTime = smeltTime;
            this.serializer = serializer;
        }

        public Builder input(Item item) {
            return this.input(new ItemStack((ItemLike)item));
        }

        public Builder input(ItemStack item) {
            return this.input(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item}));
        }

        public Builder input(TagKey<Item> tag) {
            return this.input(Ingredient.m_204132_(tag));
        }

        public Builder input(Ingredient item) {
            this.input = item;
            return this;
        }

        public void complete(String parent, String name, Consumer<FinishedRecipe> consumer) {
            consumer.accept(new CustomCookingRecipe(new ResourceLocation(parent, name), this.input, this.result, this.experience, this.smeltTime, this.serializer));
        }
    }
}

