/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class CustomShapelessCraftingRecipe
extends ShapelessRecipeBuilder.Result {
    @Nullable
    private ICondition[] recipeConditions;

    private CustomShapelessCraftingRecipe(ResourceLocation recipeId, Item result, int count, List<Ingredient> ingredients, ICondition[] recipeConditions) {
        super(recipeId, result, count, "", CraftingBookCategory.MISC, ingredients, null, null);
        this.recipeConditions = recipeConditions;
    }

    public static Builder start(Item item, int count) {
        return new Builder(item, count);
    }

    public void m_7917_(JsonObject json) {
        super.m_7917_(json);
        if (this.recipeConditions == null || this.recipeConditions.length == 0) {
            return;
        }
        JsonArray conditions = new JsonArray();
        for (ICondition condition : this.recipeConditions) {
            conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
        }
        json.add("conditions", (JsonElement)conditions);
    }

    public JsonObject m_5860_() {
        return null;
    }

    public static class Builder {
        private Item item;
        private int count;
        private List<Ingredient> ingredients = new ArrayList<Ingredient>();
        @Nullable
        private ICondition[] recipeConditions;

        private Builder(Item item, int count) {
            this.item = item;
            this.count = count;
        }

        public Builder addIngredient(Ingredient ing) {
            this.ingredients.add(ing);
            return this;
        }

        public Builder addIngredient(String parent, String tag) {
            this.ingredients.add(Ingredient.m_204132_(Builder.itemTag(new ResourceLocation(parent, tag))));
            return this;
        }

        public Builder addIngredient(TagKey<Item> tag) {
            this.ingredients.add(Ingredient.m_204132_(tag));
            return this;
        }

        public Builder addIngredient(Item item) {
            return this.addIngredient(new ItemStack((ItemLike)item));
        }

        public Builder addIngredient(ItemStack item) {
            this.ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item}));
            return this;
        }

        public Builder addConditions(ICondition ... conditions) {
            this.recipeConditions = conditions;
            return this;
        }

        public void complete(String parent, String name, Consumer<FinishedRecipe> consumer) {
            consumer.accept((FinishedRecipe)new CustomShapelessCraftingRecipe(new ResourceLocation(parent, name), this.item, this.count, this.ingredients, this.recipeConditions));
        }

        private static TagKey<Item> itemTag(ResourceLocation tag) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag);
        }
    }
}

