/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.GasIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;

public abstract class FinishedRecipeBase
implements FinishedRecipe {
    private RecipeSerializer<?> serializer;
    private ResourceLocation id;
    private List<ProbableItem> itemBiproducts = new ArrayList<ProbableItem>();
    private List<ProbableFluid> fluidBiproducts = new ArrayList<ProbableFluid>();
    private List<ProbableGas> gasBiproducts = new ArrayList<ProbableGas>();
    private List<ItemStack> itemIngredients = new ArrayList<ItemStack>();
    private List<Pair<TagKey<Item>, Integer>> tagItemIngredients = new ArrayList<Pair<TagKey<Item>, Integer>>();
    private List<FluidStack> fluidIngredients = new ArrayList<FluidStack>();
    private List<Pair<TagKey<Fluid>, Integer>> tagFluidIngredients = new ArrayList<Pair<TagKey<Fluid>, Integer>>();
    private List<GasStack> gasIngredients = new ArrayList<GasStack>();
    private List<Pair<TagKey<Gas>, GasIngWrapper>> tagGasIngredients = new ArrayList<Pair<TagKey<Gas>, GasIngWrapper>>();
    private double experience = 0.0;
    private int processTime = 0;
    private double usagePerTick = 0.0;

    protected FinishedRecipeBase(RecipeSerializer<?> serializer, double experience, int processTime, double usagePerTick) {
        this.serializer = serializer;
        this.experience = experience;
        this.processTime = processTime;
        this.usagePerTick = usagePerTick;
    }

    public FinishedRecipeBase name(RecipeCategory category, String parent, String name) {
        this.id = new ResourceLocation(parent, category.category() + "/" + name);
        return this;
    }

    public FinishedRecipeBase addItemStackInput(ItemStack stack) {
        this.itemIngredients.add(stack);
        return this;
    }

    public FinishedRecipeBase addItemTagInput(TagKey<Item> tag, int count) {
        this.tagItemIngredients.add((Pair<TagKey<Item>, Integer>)Pair.of(tag, (Object)count));
        return this;
    }

    public FinishedRecipeBase addFluidStackInput(FluidStack stack) {
        this.fluidIngredients.add(stack);
        return this;
    }

    public FinishedRecipeBase addFluidTagInput(TagKey<Fluid> tag, int count) {
        this.tagFluidIngredients.add((Pair<TagKey<Fluid>, Integer>)Pair.of(tag, (Object)count));
        return this;
    }

    public FinishedRecipeBase addGasStackInput(GasStack stack) {
        this.gasIngredients.add(stack);
        return this;
    }

    public FinishedRecipeBase addGasTagInput(TagKey<Gas> tag, int amt, int temp, int pressure) {
        this.tagGasIngredients.add((Pair<TagKey<Gas>, GasIngWrapper>)Pair.of(tag, (Object)new GasIngWrapper(amt, temp, pressure)));
        return this;
    }

    public FinishedRecipeBase addItemBiproduct(ProbableItem biproudct) {
        this.itemBiproducts.add(biproudct);
        return this;
    }

    public FinishedRecipeBase addFluidBiproduct(ProbableFluid biproduct) {
        this.fluidBiproducts.add(biproduct);
        return this;
    }

    public FinishedRecipeBase addGasBiproduct(ProbableGas biproduct) {
        this.gasBiproducts.add(biproduct);
        return this;
    }

    public void complete(Consumer<FinishedRecipe> consumer) {
        consumer.accept(this);
    }

    /*
     * WARNING - void declaration
     */
    public void m_7917_(JsonObject recipeJson) {
        int gasInputsCount;
        int fluidInputsCount;
        boolean inputsFlag = false;
        recipeJson.addProperty("ticks", (Number)this.processTime);
        recipeJson.addProperty("usagepertick", (Number)this.usagePerTick);
        int itemInputsCount = this.itemIngredients.size() + this.tagItemIngredients.size();
        if (itemInputsCount > 0) {
            JsonElement itemJson;
            CountableIngredient ing;
            inputsFlag = true;
            JsonObject itemInputs = new JsonObject();
            itemInputs.addProperty("count", (Number)itemInputsCount);
            int index = 0;
            for (ItemStack itemStack : this.itemIngredients) {
                ing = new CountableIngredient(itemStack);
                itemJson = (JsonElement)CountableIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ing).result().get();
                itemInputs.add("" + index, itemJson);
                ++index;
            }
            for (Pair pair : this.tagItemIngredients) {
                ing = new CountableIngredient((TagKey<Item>)((TagKey)pair.getFirst()), (Integer)pair.getSecond());
                itemJson = (JsonElement)CountableIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ing).result().get();
                itemInputs.add("" + index, itemJson);
                ++index;
            }
            recipeJson.add("iteminputs", (JsonElement)itemInputs);
        }
        if ((fluidInputsCount = this.fluidIngredients.size() + this.tagFluidIngredients.size()) > 0) {
            JsonElement fluidJson;
            inputsFlag = true;
            JsonObject fluidInputs = new JsonObject();
            fluidInputs.addProperty("count", (Number)fluidInputsCount);
            int index = 0;
            for (FluidStack fluidStack : this.fluidIngredients) {
                FluidIngredient ing = new FluidIngredient(fluidStack);
                fluidJson = (JsonElement)FluidIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ing).result().get();
                fluidInputs.add("" + index, fluidJson);
                ++index;
            }
            for (Pair<TagKey<Fluid>, Integer> pair : this.tagFluidIngredients) {
                FluidIngredient ing = new FluidIngredient((TagKey<Fluid>)((TagKey)pair.getFirst()), (int)((Integer)pair.getSecond()));
                fluidJson = (JsonElement)FluidIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ing).result().get();
                fluidInputs.add("" + index, fluidJson);
                ++index;
            }
            recipeJson.add("fluidinputs", (JsonElement)fluidInputs);
        }
        if ((gasInputsCount = this.gasIngredients.size() + this.tagGasIngredients.size()) > 0) {
            inputsFlag = true;
            JsonObject gasInputs = new JsonObject();
            gasInputs.addProperty("count", (Number)gasInputsCount);
            boolean bl = false;
            for (GasStack gasStack : this.gasIngredients) {
                void var9_31;
                GasIngredient ing = new GasIngredient(gasStack);
                JsonElement gasJson = (JsonElement)GasIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ing).result().get();
                gasInputs.add("" + (int)var9_31, gasJson);
                ++var9_31;
            }
            for (Pair<TagKey<Gas>, GasIngWrapper> pair : this.tagGasIngredients) {
                void var9_32;
                GasIngWrapper wrapper = (GasIngWrapper)pair.getSecond();
                GasIngredient ing = new GasIngredient((TagKey<Gas>)((TagKey)pair.getFirst()), wrapper.amt, wrapper.pressure, wrapper.temp);
                JsonElement gasJson = (JsonElement)GasIngredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ing).result().get();
                gasInputs.add("" + (int)var9_32, gasJson);
                ++var9_32;
            }
            recipeJson.add("gasinputs", (JsonElement)gasInputs);
        }
        if (!inputsFlag) {
            throw new RuntimeException("You must specify at least one item, fluid, or gas input");
        }
        this.writeOutput(recipeJson);
        recipeJson.addProperty("experience", (Number)this.experience);
        if (this.itemBiproducts.size() > 0) {
            JsonObject itemBiproducts = new JsonObject();
            itemBiproducts.addProperty("count", (Number)this.itemBiproducts.size());
            int index = 0;
            for (ProbableItem probableItem : this.itemBiproducts) {
                JsonElement itemJson = (JsonElement)ProbableItem.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)probableItem).result().get();
                itemBiproducts.add("" + index, itemJson);
                ++index;
            }
            recipeJson.add("itembi", (JsonElement)itemBiproducts);
        }
        if (this.fluidBiproducts.size() > 0) {
            JsonObject fluidBiproducts = new JsonObject();
            fluidBiproducts.addProperty("count", (Number)this.fluidBiproducts.size());
            int index = 0;
            for (ProbableFluid probableFluid : this.fluidBiproducts) {
                JsonElement fluidJson = (JsonElement)ProbableFluid.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)probableFluid).result().get();
                fluidBiproducts.add("" + index, fluidJson);
                ++index;
            }
            recipeJson.add("fluidbi", (JsonElement)fluidBiproducts);
        }
        if (this.gasBiproducts.size() > 0) {
            JsonObject gasBiproducts = new JsonObject();
            gasBiproducts.addProperty("count", (Number)this.gasBiproducts.size());
            int index = 0;
            for (ProbableGas probableGas : this.gasBiproducts) {
                JsonElement gasJson = (JsonElement)ProbableGas.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)probableGas).result().get();
                gasBiproducts.add("" + index, gasJson);
                ++index;
            }
            recipeJson.add("gasbi", (JsonElement)gasBiproducts);
        }
    }

    public ResourceLocation m_6445_() {
        return this.id;
    }

    public RecipeSerializer<?> m_6637_() {
        return this.serializer;
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }

    public abstract void writeOutput(JsonObject var1);

    public static enum RecipeCategory {
        ITEM_2_ITEM,
        ITEM_2_FLUID,
        FLUID_ITEM_2_ITEM,
        FLUID_ITEM_2_FLUID,
        FLUID_2_ITEM,
        FLUID_2_FLUID,
        FLUID_2_GAS,
        FLUID_ITEM_2_GAS;


        public String category() {
            return this.toString().toLowerCase(Locale.ROOT).replaceAll("_", "");
        }
    }

    public record GasIngWrapper(int amt, int temp, int pressure) {
    }
}

