/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.block;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.IWrenchable;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public abstract class GenericEntityBlock
extends BaseEntityBlock
implements IWrenchable {
    protected GenericEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level lvl, BlockState state, BlockEntityType<T> type) {
        return (l, pos, s, tile) -> {
            GenericTile generic;
            Object patt2375$temp;
            if (tile instanceof GenericTile && (patt2375$temp = (generic = (GenericTile)tile).getComponent(IComponentType.Tickable)) instanceof ComponentTickable) {
                ComponentTickable tickable = (ComponentTickable)patt2375$temp;
                tickable.performTick(l);
            }
        };
    }

    @Override
    public void onRotate(ItemStack stack, BlockPos pos, Player player) {
        if (player.m_9236_().m_8055_(pos).m_61138_((Property)VoltaicBlockStates.FACING)) {
            BlockState state = this.m_6843_(player.m_9236_().m_8055_(pos), Rotation.CLOCKWISE_90);
            player.m_9236_().m_46597_(pos, state);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (state.m_61138_((Property)VoltaicBlockStates.FACING)) {
            return (BlockState)state.m_61124_((Property)VoltaicBlockStates.FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)VoltaicBlockStates.FACING)));
        }
        return super.m_6843_(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (state.m_61138_((Property)VoltaicBlockStates.FACING)) {
            return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)VoltaicBlockStates.FACING)));
        }
        return super.m_6943_(state, mirrorIn);
    }

    @Override
    public void onPickup(ItemStack stack, BlockPos pos, Player player) {
        Level world = player.m_9236_();
        world.m_46953_(pos, true, (Entity)player);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity tile = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (tile instanceof GenericTile) {
            GenericTile machine = (GenericTile)tile;
            ItemStack stack = new ItemStack((ItemLike)this);
            ComponentInventory inv = (ComponentInventory)machine.getComponent(IComponentType.Inventory);
            if (inv != null) {
                ComponentElectrodynamic electro;
                double joules;
                Containers.m_19010_((Level)machine.m_58904_(), (BlockPos)machine.m_58899_(), inv.getItems());
                if (machine.hasComponent(IComponentType.Electrodynamic) && (joules = (electro = (ComponentElectrodynamic)machine.getComponent(IComponentType.Electrodynamic)).getJoulesStored()) > 0.0) {
                    stack.m_41784_().m_128347_("joules", joules);
                }
            }
            return Arrays.asList(stack);
        }
        return super.m_49635_(state, builder);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            if (newState.m_60795_() || !newState.m_60713_(state.m_60734_())) {
                generic.onBlockDestroyed();
            } else {
                generic.onBlockStateUpdate(state, newState);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            generic.onNeightborChanged(neighbor, false);
        }
    }

    public void m_6807_(BlockState newState, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(newState, level, pos, oldState, isMoving);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            generic.onPlace(oldState, isMoving);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        super.m_6861_(state, level, pos, block, neighbor, isMoving);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            generic.onNeightborChanged(neighbor, true);
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            return generic.getComparatorSignal();
        }
        return super.m_6782_(state, level, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            return generic.use(player, handIn, hit);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            return generic.getDirectSignal(direction);
        }
        return super.m_6376_(state, level, pos, direction);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile generic = (GenericTile)blockEntity;
            return generic.getSignal(direction);
        }
        return super.m_6378_(state, level, pos, direction);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile tile = (GenericTile)blockEntity;
            tile.onEntityInside(state, level, pos, entity);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericTile) {
            GenericTile tile = (GenericTile)blockEntity;
            tile.setPlacedBy(placer, stack);
        }
    }
}

