/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.gauges;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.api.screen.component.FluidTankSupplier;
import voltaic.common.packet.NetworkHandler;
import voltaic.common.packet.types.server.PacketUpdateCarriedItemServer;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.gauges.AbstractScreenComponentGauge;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

@OnlyIn(value=Dist.CLIENT)
public class ScreenComponentFluidGauge
extends AbstractScreenComponentGauge {
    public FluidTankSupplier fluidInfoHandler;

    public ScreenComponentFluidGauge(FluidTankSupplier fluidInfoHandler, int x, int y) {
        super(x, y);
        this.fluidInfoHandler = fluidInfoHandler;
    }

    @Override
    protected int getScaledLevel() {
        IFluidTank tank = this.fluidInfoHandler.getTank();
        if (tank != null && tank.getFluidAmount() > 0 && tank.getCapacity() > 0) {
            return tank.getFluidAmount() * (AbstractScreenComponentGauge.GaugeTextures.BACKGROUND_DEFAULT.textureHeight() - 2) / tank.getCapacity();
        }
        return 0;
    }

    @Override
    protected void applyColor() {
        FluidStack fluidStack;
        IFluidTank tank = this.fluidInfoHandler.getTank();
        if (tank != null && !(fluidStack = tank.getFluid()).isEmpty()) {
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            RenderingUtils.setShaderColor(new Color(extensions.getTintColor(fluidStack)));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        IFluidTank tank = this.fluidInfoHandler.getTank();
        if (tank != null) {
            FluidStack fluidStack = tank.getFluid();
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            return extensions.getStillTexture();
        }
        return this.texture.getLocation();
    }

    @Override
    protected List<? extends FormattedCharSequence> getTooltips() {
        ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
        IFluidTank tank = this.fluidInfoHandler.getTank();
        if (tank != null) {
            FluidStack fluidStack = tank.getFluid();
            if (fluidStack.getAmount() > 0) {
                tooltips.add(Component.m_237115_((String)fluidStack.getTranslationKey()).m_7532_());
                tooltips.add(VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets(tank.getFluidAmount()), (Component)ChatFormatter.formatFluidMilibuckets(tank.getCapacity())).m_130940_(ChatFormatting.GRAY).m_7532_());
            } else {
                tooltips.add(VoltaicTextUtils.ratio((Component)Component.m_237113_((String)"0"), (Component)ChatFormatter.formatFluidMilibuckets(tank.getCapacity())).m_130940_(ChatFormatting.GRAY).m_7532_());
            }
        }
        return tooltips;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isActiveAndVisible() && this.isValidClick(button) && this.isInClickRegion(mouseX, mouseY)) {
            this.onMouseClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClick(button)) {
            this.onMouseRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY) {
        PropertyFluidTank x;
        PropertyFluidTank tank;
        IFluidTank iFluidTank = this.fluidInfoHandler.getTank();
        PropertyFluidTank propertyFluidTank = tank = iFluidTank instanceof PropertyFluidTank ? (x = (PropertyFluidTank)iFluidTank) : null;
        if (tank == null) {
            return;
        }
        GenericScreen screen = (GenericScreen)this.gui;
        GenericTile owner = (GenericTile)((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost();
        if (owner == null) {
            return;
        }
        ItemStack stack = ((GenericContainer)screen.m_6262_()).m_142621_();
        if (stack.m_41619_() || stack.m_41784_().m_128471_("hasclickedonfluidgauge")) {
            return;
        }
        IFluidHandlerItem handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(CapabilityUtils.EMPTY_FLUID_ITEM);
        if (handler == CapabilityUtils.EMPTY_FLUID_ITEM) {
            return;
        }
        FluidStack drainedSourceFluid = tank.getFluid().copy();
        int taken = handler.fill(drainedSourceFluid, IFluidHandler.FluidAction.EXECUTE);
        if (taken > 0) {
            tank.drain(taken, IFluidHandler.FluidAction.EXECUTE);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11781_, (float)1.0f));
            stack = handler.getContainer();
            stack.m_41784_().m_128379_("hasclickedonfluidgauge", true);
            NetworkHandler.CHANNEL.sendToServer((Object)new PacketUpdateCarriedItemServer(stack.m_41777_(), ((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost().m_58899_(), Minecraft.m_91087_().f_91074_.m_20148_()));
            ((GenericContainer)screen.m_6262_()).m_142503_(stack);
            return;
        }
        for (int i = 0; i < handler.getTanks(); ++i) {
            drainedSourceFluid = handler.getFluidInTank(i);
            taken = tank.fill(drainedSourceFluid, IFluidHandler.FluidAction.EXECUTE);
            if (taken <= 0) continue;
            handler.drain(taken, IFluidHandler.FluidAction.EXECUTE);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11778_, (float)1.0f));
            stack = handler.getContainer();
            stack.m_41784_().m_128379_("hasclickedonfluidgauge", true);
            NetworkHandler.CHANNEL.sendToServer((Object)new PacketUpdateCarriedItemServer(stack.m_41777_(), ((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost().m_58899_(), Minecraft.m_91087_().f_91074_.m_20148_()));
            ((GenericContainer)screen.m_6262_()).m_142503_(stack);
            return;
        }
    }
}

