/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.wrapper;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentInventoryIO;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class WrapperInventoryIO {
    private ScreenComponentInventoryIO[] ioArr = new ScreenComponentInventoryIO[6];
    private ScreenComponentSimpleLabel label;
    public ScreenComponentButton<?> button;
    private final GenericScreen<?> screen;
    private final BiFunction<SlotGeneric, Integer, Color> defaultColorSupplier;
    private Consumer<Boolean> additionalToHide = show -> {};

    public WrapperInventoryIO(GenericScreen<?> screen, int tabX, int tabY, int slotStartX, int slotStartY, int labelX, int labelY) {
        this(screen, tabX, tabY, slotStartX, slotStartY, labelX, labelY, (slot, index) -> Color.WHITE);
    }

    public WrapperInventoryIO(GenericScreen<?> screen, int tabX, int tabY, int slotStartX, int slotStartY, int labelX, int labelY, BiFunction<SlotGeneric, Integer, Color> defaultColorSupplier) {
        this.screen = screen;
        this.defaultColorSupplier = defaultColorSupplier;
        this.button = (ScreenComponentButton)((ScreenComponentButton)new ScreenComponentButton(ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, tabX, tabY).setOnPress(button -> {
            boolean bl = button.isPressed = !button.isPressed;
            if (button.isPressed) {
                this.additionalToHide.accept(false);
                this.screen.playerInvLabel.setVisible(false);
                this.setColoredSlots();
                this.updateVisibility(true);
            } else {
                this.additionalToHide.accept(true);
                this.screen.playerInvLabel.setVisible(true);
                this.resetSlots();
                this.updateVisibility(false);
            }
        })).onTooltip((graphics, but, xAxis, yAxis) -> {
            ScreenComponentButton button = (ScreenComponentButton)but;
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(VoltaicTextUtils.tooltip("inventoryio", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            if (!button.isPressed) {
                tooltips.add(VoltaicTextUtils.tooltip("inventoryio.presstoshow", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            } else {
                tooltips.add(VoltaicTextUtils.tooltip("inventoryio.presstohide", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            graphics.m_280666_(this.screen.getFontRenderer(), tooltips, xAxis, yAxis);
        }).setIcon(ScreenComponentSlot.IconType.INVENTORY_IO);
        screen.addComponent(this.button);
        this.label = new ScreenComponentSimpleLabel(labelX, labelY, 10, Color.TEXT_GRAY, (Component)VoltaicTextUtils.tooltip("inventoryio.slotmap", new Object[0]));
        this.screen.addComponent(this.label);
        this.label.setVisible(false);
        this.ioArr[0] = new ScreenComponentInventoryIO(slotStartX, slotStartY + 1, Direction.UP);
        this.screen.addComponent(this.ioArr[0]);
        this.ioArr[1] = new ScreenComponentInventoryIO(slotStartX, slotStartY + 26, Direction.NORTH);
        this.screen.addComponent(this.ioArr[1]);
        this.ioArr[2] = new ScreenComponentInventoryIO(slotStartX, slotStartY + 52 - 1, Direction.DOWN);
        this.screen.addComponent(this.ioArr[2]);
        this.ioArr[3] = new ScreenComponentInventoryIO(slotStartX - 25, slotStartY + 26, Direction.EAST);
        this.screen.addComponent(this.ioArr[3]);
        this.ioArr[4] = new ScreenComponentInventoryIO(slotStartX + 25, slotStartY + 26, Direction.WEST);
        this.screen.addComponent(this.ioArr[4]);
        this.ioArr[5] = new ScreenComponentInventoryIO(slotStartX + 25, slotStartY + 52 - 1, Direction.SOUTH);
        this.screen.addComponent(this.ioArr[5]);
        for (ScreenComponentInventoryIO io : this.ioArr) {
            io.setVisible(false);
        }
    }

    public WrapperInventoryIO hideAdditional(Consumer<Boolean> additionalToHide) {
        this.additionalToHide = additionalToHide;
        return this;
    }

    public void updateVisibility(boolean show) {
        for (ScreenComponentInventoryIO io : this.ioArr) {
            io.setVisible(show);
        }
        this.label.setVisible(show);
    }

    public void setColoredSlots() {
        int i;
        for (i = ((GenericContainer)this.screen.m_6262_()).getAdditionalSlotCount(); i < ((GenericContainer)this.screen.m_6262_()).f_38839_.size(); ++i) {
            ((SlotGeneric)((GenericContainer)this.screen.m_6262_()).f_38839_.get(i)).setActive(false);
        }
        for (i = 0; i < ((GenericContainer)this.screen.m_6262_()).getAdditionalSlotCount(); ++i) {
            SlotGeneric generic = (SlotGeneric)((GenericContainer)this.screen.m_6262_()).f_38839_.get(i);
            if (generic.ioColor == null) continue;
            this.screen.slots.get(i).setColor(generic.ioColor);
        }
    }

    public void resetSlots() {
        int i;
        for (i = ((GenericContainer)this.screen.m_6262_()).getAdditionalSlotCount(); i < ((GenericContainer)this.screen.m_6262_()).f_38839_.size(); ++i) {
            ((SlotGeneric)((GenericContainer)this.screen.m_6262_()).f_38839_.get(i)).setActive(true);
        }
        for (i = 0; i < ((GenericContainer)this.screen.m_6262_()).getAdditionalSlotCount(); ++i) {
            SlotGeneric generic = (SlotGeneric)((GenericContainer)this.screen.m_6262_()).f_38839_.get(i);
            if (generic.ioColor == null) continue;
            this.screen.slots.get(i).setColor(this.defaultColorSupplier.apply(generic, i));
        }
    }
}

