/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.types;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import voltaic.client.model.block.modelproperties.ModelPropertyConnections;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.types.IConnectTile;

public abstract class GenericConnectTile
extends GenericTile
implements IConnectTile {
    public static final int DOWN_MASK = 15;
    public static final int UP_MASK = 240;
    public static final int NORTH_MASK = 3840;
    public static final int SOUTH_MASK = 61440;
    public static final int WEST_MASK = 983040;
    public static final int EAST_MASK = 0xF00000;
    protected EnumConnectType[] connectionsArr = new EnumConnectType[]{EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE};
    public final SingleProperty<Integer> connections = this.property((SingleProperty)((AbstractProperty)new SingleProperty<Integer>(PropertyTypes.INTEGER, "connections", Integer.valueOf(0)).onChange((property, old) -> {
        this.requestModelDataUpdate();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        }
        this.connectionsArr = this.readConnectionsInternal((Integer)property.getValue());
    }).onTileLoaded(property -> {
        this.requestModelDataUpdate();
        this.connectionsArr = this.readConnectionsInternal((Integer)property.getValue());
    }).setNoUpdateServer()).setShouldUpdateOnChange());
    public final SingleProperty<BlockState> camoflaugedBlock = (SingleProperty)this.property(new SingleProperty<BlockState>(PropertyTypes.BLOCK_STATE, "camoflaugedblock", Blocks.f_50016_.m_49966_())).onChange((property, block) -> {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
    }).onTileLoaded(property -> this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_)).setShouldUpdateOnChange();
    public final SingleProperty<BlockState> scaffoldBlock = (SingleProperty)this.property(new SingleProperty<BlockState>(PropertyTypes.BLOCK_STATE, "scaffoldblock", Blocks.f_50016_.m_49966_())).onChange((property, block) -> {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
    }).onTileLoaded(property -> this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_)).setShouldUpdateOnChange();

    public GenericConnectTile(BlockEntityType<?> tile, BlockPos pos, BlockState state) {
        super(tile, pos, state);
        this.addComponent(new ComponentPacketHandler(this));
    }

    public void setCamoBlock(BlockState block) {
        this.camoflaugedBlock.setValue(block);
        this.m_6596_();
    }

    public BlockState getCamoBlock() {
        return (BlockState)this.camoflaugedBlock.getValue();
    }

    public boolean isCamoAir() {
        return this.getCamoBlock().m_60795_();
    }

    public void setScaffoldBlock(BlockState scaffold) {
        this.scaffoldBlock.setValue(scaffold);
        this.m_6596_();
    }

    public BlockState getScaffoldBlock() {
        return (BlockState)this.scaffoldBlock.getValue();
    }

    public boolean isScaffoldAir() {
        return this.getScaffoldBlock().m_60795_();
    }

    public EnumConnectType readConnection(Direction dir, int connections) {
        if (connections == 0) {
            return EnumConnectType.NONE;
        }
        int extracted = 0;
        switch (dir) {
            case DOWN: {
                extracted = connections & 0xF;
                break;
            }
            case UP: {
                extracted = connections & 0xF0;
                break;
            }
            case NORTH: {
                extracted = connections & 0xF00;
                break;
            }
            case SOUTH: {
                extracted = connections & 0xF000;
                break;
            }
            case WEST: {
                extracted = connections & 0xF0000;
                break;
            }
            case EAST: {
                extracted = connections & 0xF00000;
                break;
            }
        }
        return EnumConnectType.values()[extracted >> dir.ordinal() * 4];
    }

    public boolean writeConnections(Direction[] dirs, EnumConnectType[] connections) {
        int connectionData = (Integer)this.connections.getValue();
        for (Direction dir : dirs) {
            connectionData = (switch (dir) {
                case Direction.DOWN -> connectionData & 0xFFFFFFF0;
                case Direction.UP -> connectionData & 0xFFFFFF0F;
                case Direction.NORTH -> connectionData & 0xFFFFF0FF;
                case Direction.SOUTH -> connectionData & 0xFFFF0FFF;
                case Direction.WEST -> connectionData & 0xFFF0FFFF;
                case Direction.EAST -> connectionData & 0xFF0FFFFF;
                default -> 0;
            }) | connections[dir.ordinal()].ordinal() << dir.ordinal() * 4;
        }
        this.connections.setValue(connectionData);
        return this.connections.isDirty();
    }

    public boolean writeConnection(Direction dir, EnumConnectType connection) {
        int connectionData = (Integer)this.connections.getValue();
        connectionData = (switch (dir) {
            case Direction.DOWN -> connectionData & 0xFFFFFFF0;
            case Direction.UP -> connectionData & 0xFFFFFF0F;
            case Direction.NORTH -> connectionData & 0xFFFFF0FF;
            case Direction.SOUTH -> connectionData & 0xFFFF0FFF;
            case Direction.WEST -> connectionData & 0xFFF0FFFF;
            case Direction.EAST -> connectionData & 0xFF0FFFFF;
            default -> 0;
        }) | connection.ordinal() << dir.ordinal() * 4;
        this.connections.setValue(connectionData);
        return this.connections.isDirty();
    }

    @Override
    public EnumConnectType[] readConnections() {
        return this.connectionsArr;
    }

    private EnumConnectType[] readConnectionsInternal(int connections) {
        EnumConnectType[] arr = new EnumConnectType[6];
        for (Direction dir : Direction.values()) {
            arr[dir.ordinal()] = this.readConnection(dir, connections);
        }
        return arr;
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with((ModelProperty)ModelPropertyConnections.INSTANCE, () -> this.readConnections()).build();
    }
}

