/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;
import voltaic.Voltaic;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderingUtils {
    private static final Matrix4f ITEM_MATRIX = new Matrix4f().scaling(1.0f, -1.0f, 1.0f);
    public static final boolean[] ALL_FACES = new boolean[]{true, true, true, true, true, true};

    public static void renderStar(PoseStack stack, MultiBufferSource bufferIn, float time, int starFrags, float r, float g, float b, float a, boolean star) {
        stack.m_85836_();
        try {
            float f5 = time / 200.0f;
            Random random = new Random(432L);
            VertexConsumer vertexconsumer2 = bufferIn.m_6299_(RenderType.m_110502_());
            stack.m_85836_();
            stack.m_85837_(0.0, -1.0, 0.0);
            for (int i = 0; i < starFrags; ++i) {
                stack.m_252781_(MathUtils.rotVectorQuaternionDeg(random.nextFloat() * 360.0f, MathUtils.XP));
                stack.m_252781_(MathUtils.rotVectorQuaternionDeg(random.nextFloat() * 360.0f, MathUtils.YP));
                stack.m_252781_(MathUtils.rotVectorQuaternionDeg(random.nextFloat() * 360.0f, MathUtils.ZP));
                stack.m_252781_(MathUtils.rotVectorQuaternionDeg(random.nextFloat() * 360.0f, MathUtils.XP));
                stack.m_252781_(MathUtils.rotVectorQuaternionDeg(random.nextFloat() * 360.0f, MathUtils.YP));
                stack.m_252781_(MathUtils.rotVectorQuaternionDeg(random.nextFloat() * 360.0f + f5 * 90.0f, MathUtils.ZP));
                float f3 = random.nextFloat() * 20.0f + 1.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + (float)(star ? 0 : 100);
                Matrix4f matrix4f = stack.m_85850_().m_252922_();
                vertexconsumer2.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_252986_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_252986_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_252986_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_252986_(matrix4f, 0.0f, f3, 1.0f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_252986_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
            }
            stack.m_85849_();
            if (bufferIn instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferIn;
                source.m_109912_(RenderType.m_110502_());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        stack.m_85849_();
    }

    public static void renderModel(BakedModel model, BlockEntity tile, RenderType type, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Minecraft.m_91087_().m_91291_().m_115143_(new ItemStack((ItemLike)(type == RenderType.m_110466_() ? Items.f_42175_ : Blocks.f_50069_)), ItemDisplayContext.NONE, false, stack, buffer, combinedLightIn, combinedOverlayIn, model);
    }

    public static void prepareRotationalTileModel(BlockEntity tile, PoseStack stack) {
        BlockState state = tile.m_58900_();
        stack.m_85837_(0.5, 0.4375, 0.5);
        if (state.m_61138_((Property)VoltaicBlockStates.FACING)) {
            Direction facing = (Direction)state.m_61143_((Property)VoltaicBlockStates.FACING);
            if (facing == Direction.NORTH) {
                stack.m_252781_(MathUtils.rotQuaternionDeg(0.0f, 90.0f, 0.0f));
            } else if (facing == Direction.SOUTH) {
                stack.m_252781_(MathUtils.rotQuaternionDeg(0.0f, 270.0f, 0.0f));
            } else if (facing == Direction.WEST) {
                stack.m_252781_(MathUtils.rotQuaternionDeg(0.0f, 180.0f, 0.0f));
            }
        }
    }

    public static void renderSolidColorBox(PoseStack stack, Minecraft minecraft, VertexConsumer builder, AABB box, float r, float g, float b, float a, int light, int overlay, @Nonnull boolean[] renderedFaces) {
        TextureAtlasSprite sp = (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(Voltaic.vanillarl("block/white_wool"));
        RenderingUtils.renderFilledBox(stack, builder, box, r, g, b, a, sp.m_118409_(), sp.m_118411_(), sp.m_118410_(), sp.m_118412_(), light, overlay, renderedFaces);
    }

    public static void renderFluidBox(PoseStack stack, Minecraft minecraft, VertexConsumer builder, AABB box, FluidStack fluidStack, int light, int overlay, @Nonnull boolean[] renderedFaces) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite sp = (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(attributes.getStillTexture());
        Color color = new Color(attributes.getTintColor(fluidStack));
        RenderingUtils.renderFilledBox(stack, builder, box, color.rFloat(), color.gFloat(), color.bFloat(), color.aFloat(), sp.m_118409_(), sp.m_118411_(), sp.m_118410_(), sp.m_118412_(), light, overlay, renderedFaces);
    }

    public static void renderFilledBox(PoseStack stack, VertexConsumer builder, AABB box, float r, float g, float b, float a, float uMin, float vMin, float uMax, float vMax, int light, int overlay, @Nonnull boolean[] renderedFaces) {
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        PoseStack.Pose pose = stack.m_85850_();
        float minX = (float)box.f_82288_;
        float minY = (float)box.f_82289_;
        float minZ = (float)box.f_82290_;
        float maxX = (float)box.f_82291_;
        float maxY = (float)box.f_82292_;
        float maxZ = (float)box.f_82293_;
        if (renderedFaces[0]) {
            builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
        }
        if (renderedFaces[1]) {
            builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (renderedFaces[2]) {
            builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (renderedFaces[3]) {
            builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (renderedFaces[4]) {
            builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (renderedFaces[5]) {
            builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(overlay).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
        }
    }

    public static void renderFilledBoxNoOverlay(PoseStack stack, VertexConsumer builder, AABB box, float r, float g, float b, float a, float uMin, float vMin, float uMax, float vMax, int light, @Nonnull boolean[] renderedFaces) {
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        PoseStack.Pose pose = stack.m_85850_();
        float minX = (float)box.f_82288_;
        float minY = (float)box.f_82289_;
        float minZ = (float)box.f_82290_;
        float maxX = (float)box.f_82291_;
        float maxY = (float)box.f_82292_;
        float maxZ = (float)box.f_82293_;
        if (renderedFaces[0]) {
            builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
        }
        if (renderedFaces[1]) {
            builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (renderedFaces[2]) {
            builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (renderedFaces[3]) {
            builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (renderedFaces[4]) {
            builder.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (renderedFaces[5]) {
            builder.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(uMin, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
        }
    }

    public static void renderItemScaled(GuiGraphics graphics, Item item, int x, int y, float scale) {
        ItemStack stack = new ItemStack((ItemLike)item);
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, (Level)null, (LivingEntity)null, 0);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
        try {
            boolean flag;
            poseStack.m_252931_(ITEM_MATRIX);
            poseStack.m_85841_(16.0f, 16.0f, 16.0f);
            poseStack.m_85841_(scale, scale, scale);
            boolean bl = flag = !model.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            minecraft.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, model);
            graphics.m_280262_();
            if (flag) {
                Lighting.m_84931_();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
            crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
            crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
            crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
            throw new ReportedException(crashreport);
        }
        poseStack.m_85849_();
    }

    public static void blitCustomShader(PoseStack matrixStack, int x, int y, int u, int v, int textWidth, int textHeight, int imgWidth, int imgHeight, Supplier<ShaderInstance> shader) {
        float x0 = x;
        float x1 = x + textWidth;
        float y0 = y;
        float y1 = y + textHeight;
        float blitOffset = 0.0f;
        float minU = ((float)u + 0.0f) / (float)imgWidth;
        float maxU = ((float)u + (float)textWidth) / (float)imgWidth;
        float minV = ((float)v + 0.0f) / (float)imgHeight;
        float maxV = ((float)v + (float)textHeight) / (float)imgHeight;
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        RenderSystem.setShader(shader);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x0, y1, blitOffset).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, x1, y1, blitOffset).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, x1, y0, blitOffset).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix, x0, y0, blitOffset).m_7421_(minU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShader(GameRenderer::m_172817_);
    }

    public static void bindTexture(ResourceLocation resource) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
    }

    public static void setShaderColor(Color color) {
        RenderSystem.setShaderColor((float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)color.aFloat());
    }

    public static RenderType beaconType() {
        return RenderType.m_110460_((ResourceLocation)Voltaic.vanillarl("textures/entity/beacon_beam.png"), (boolean)true);
    }

    public static void resetShaderColor() {
        RenderingUtils.setShaderColor(Color.WHITE);
    }
}

