/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class WorldUtils {
    public static final double CHUNK_WIDTH = 16.0;
    private static HashMap<ChunkPos, LevelChunk> chunkCache = new HashMap();

    public static List<LevelChunk> getChunksForRadius(LevelReader world, BlockPos pos, int xRadius, int zRadius) {
        xRadius = Math.abs(xRadius);
        zRadius = Math.abs(zRadius);
        ArrayList<LevelChunk> chunks = new ArrayList<LevelChunk>(WorldUtils.getChunksForQuadrant(world, pos, xRadius, zRadius, 1, 1));
        for (LevelChunk chunk : WorldUtils.getChunksForQuadrant(world, pos, xRadius, zRadius, -1, 1)) {
            if (chunks.contains(chunk)) continue;
            chunks.add(chunk);
        }
        for (LevelChunk chunk : WorldUtils.getChunksForQuadrant(world, pos, xRadius, zRadius, -1, -1)) {
            if (chunks.contains(chunk)) continue;
            chunks.add(chunk);
        }
        for (LevelChunk chunk : WorldUtils.getChunksForQuadrant(world, pos, xRadius, zRadius, 1, -1)) {
            if (chunks.contains(chunk)) continue;
            chunks.add(chunk);
        }
        return chunks;
    }

    private static List<LevelChunk> getChunksForQuadrant(LevelReader world, BlockPos pos, int xRadius, int zRadius, int xSign, int zSign) {
        ArrayList<LevelChunk> quadrant = new ArrayList<LevelChunk>();
        int posX = pos.m_123341_();
        int posZ = pos.m_123343_();
        int posY = pos.m_123342_();
        int chunkRadiusX = (int)Math.ceil((double)xRadius / 16.0);
        int chunkRadiusZ = (int)Math.ceil((double)zRadius / 16.0);
        for (int i = 0; i <= chunkRadiusX; ++i) {
            for (int j = 0; j <= chunkRadiusZ; ++j) {
                quadrant.add((LevelChunk)world.m_46865_(new BlockPos(posX, posY, posZ)));
                posZ = (int)((double)posZ + (double)zSign * 16.0);
            }
            posZ = pos.m_123343_();
            posX = (int)((double)posX + (double)xSign * 16.0);
        }
        return quadrant;
    }

    public static BlockPos getClosestBlockToCenter(LevelReader world, BlockPos startPos, int maxRadius, Block ... caseBlocks) {
        for (int radius = 1; radius <= maxRadius; ++radius) {
            int iMin = -radius;
            int iMax = radius;
            int jMax = radius;
            int jMin = -radius;
            for (Direction dir : Direction.values()) {
                Vec3i orientation = dir.m_122436_();
                for (int i = iMin; i < iMax; ++i) {
                    for (int j = jMin; j < jMax; ++j) {
                        int x = 0;
                        int y = 0;
                        int z = 0;
                        if (orientation.m_123341_() != 0) {
                            x = orientation.m_123341_() * radius;
                            y += i;
                            z += j;
                        } else if (orientation.m_123342_() != 0) {
                            x += i;
                            y = orientation.m_123342_() * radius;
                            z += j;
                        } else if (orientation.m_123343_() != 0) {
                            x += i;
                            y += j;
                            z = orientation.m_123343_() * radius;
                        }
                        BlockPos currentBlockPos = new BlockPos(x + startPos.m_123341_(), y + startPos.m_123342_(), z + startPos.m_123343_());
                        if (!WorldUtils.compareStates(world.m_8055_(currentBlockPos), caseBlocks)) continue;
                        return currentBlockPos;
                    }
                }
            }
        }
        return startPos;
    }

    private static boolean compareStates(BlockState state, Block ... caseBlocks) {
        for (Block caseBlock : caseBlocks) {
            if (!state.m_60713_(caseBlock)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<BlockEntity> getNearbyTiles(LevelReader level, BlockPos pos, int radius) {
        ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos offset = pos.m_7918_(i, j, k);
                    BlockEntity entity = level.m_7702_(offset);
                    if (entity == null) continue;
                    list.add(entity);
                }
            }
        }
        return list;
    }

    public static void clearChunkCache() {
        for (LevelChunk chunk : chunkCache.values()) {
            ServerLevel level = (ServerLevel)chunk.m_62953_();
            chunk.m_8092_(true);
            LevelLightEngine lightManager = level.m_5518_();
            lightManager.m_9335_(chunk.m_7697_(), false);
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(chunk, lightManager, null, null);
            level.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_9829_((Packet)packet));
            level.m_7726_().m_6692_(chunk.m_7697_(), true);
        }
        chunkCache.clear();
    }

    public static void fastRemoveBlockExplosion(ServerLevel level, BlockPos pos) {
        if (!level.m_151570_(pos)) {
            LevelChunk chunk = WorldUtils.getChunk(level, pos);
            LevelChunkSection storage = WorldUtils.getBlockStorage(pos);
            BlockState oldState = chunk.m_8055_(pos);
            Block block = oldState.m_60734_();
            if (oldState != Blocks.f_50016_.m_49966_() && oldState != Blocks.f_50626_.m_49966_() && oldState.m_60800_((BlockGetter)level, pos) >= 0.0f) {
                if (block instanceof EntityBlock || block instanceof Fallable) {
                    level.m_7471_(pos, false);
                    level.m_5518_().m_7174_(pos);
                    return;
                }
                if (storage != null) {
                    storage.m_62986_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF, Blocks.f_50016_.m_49966_());
                    level.m_5518_().m_7174_(pos);
                }
            }
        }
    }

    private static LevelChunkSection getBlockStorage(BlockPos pos) {
        LevelChunk chunk = WorldUtils.getChunk(null, pos);
        return chunk.m_183278_(chunk.m_151564_(pos.m_123342_()));
    }

    private static LevelChunk getChunk(ServerLevel level, BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!chunkCache.containsKey(cp)) {
            chunkCache.put(cp, level.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4));
        }
        return chunkCache.get(cp);
    }

    public static double distanceBetweenPositions(BlockPos a, BlockPos b) {
        return Mth.m_14116_((float)(Mth.m_144944_((int)(a.m_123341_() - b.m_123341_())) + Mth.m_144944_((int)(a.m_123342_() - b.m_123342_())) + Mth.m_144944_((int)(a.m_123343_() - b.m_123343_()))));
    }

    public static Direction getDirectionFromPosDelta(BlockPos from, BlockPos to) {
        BlockPos delta = to.m_121996_((Vec3i)from);
        return Direction.m_122378_((int)delta.m_123341_(), (int)delta.m_123342_(), (int)delta.m_123343_());
    }

    public static boolean shouldUpdateFromRedstoneChange(Level world, BlockPos ourPos, BlockPos neighborPos) {
        int neighborSignal;
        int bestSignal = world.m_277086_(ourPos);
        return bestSignal == (neighborSignal = world.m_277185_(neighborPos, WorldUtils.getDirectionFromPosDelta(ourPos, neighborPos)));
    }
}

