/*
 * Decompiled with CFR 0.152.
 */
package com.redstonia.redstoniaui.client;

import com.mojang.blaze3d.platform.Window;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Struct;

@Mod.EventBusSubscriber(modid="redstoniaui", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WindowConfig {
    private static boolean iconsSet = false;
    private static int tickCounter = 0;
    private static final String CUSTOM_TITLE_PREFIX = "Redstonia - ";

    public static void setupWindow() {
        Minecraft mc = Minecraft.m_91087_();
        if (!iconsSet) {
            try {
                WindowConfig.setWindowIcons(mc);
                iconsSet = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WindowConfig.updateWindowTitle(mc);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++tickCounter >= 20) {
            tickCounter = 0;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91268_() != null) {
                WindowConfig.updateWindowTitle(mc);
            }
        }
    }

    private static void setWindowIcons(Minecraft mc) throws Exception {
        Window window = mc.m_91268_();
        long glfwWindow = window.m_85439_();
        try (InputStream icon16 = ((Resource)mc.m_91098_().m_213713_(new ResourceLocation("redstoniaui", "icons/icon_16x16.png")).get()).m_215507_();
             InputStream icon32 = ((Resource)mc.m_91098_().m_213713_(new ResourceLocation("redstoniaui", "icons/icon_32x32.png")).get()).m_215507_();){
            GLFWImage img16 = WindowConfig.loadIcon(icon16);
            GLFWImage img32 = WindowConfig.loadIcon(icon32);
            GLFWImage.Buffer buffer = GLFWImage.malloc((int)2);
            buffer.put(0, (Struct)img16);
            buffer.put(1, (Struct)img32);
            GLFW.glfwSetWindowIcon((long)glfwWindow, (GLFWImage.Buffer)buffer);
            img16.free();
            img32.free();
            buffer.free();
        }
    }

    private static GLFWImage loadIcon(InputStream stream) throws Exception {
        byte[] bytes = stream.readAllBytes();
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
        buffer.put(bytes).flip();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            IntBuffer h = stack.mallocInt(1);
            IntBuffer comp = stack.mallocInt(1);
            ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)buffer, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)4);
            if (image == null) {
                throw new Exception("Failed to load image: " + STBImage.stbi_failure_reason());
            }
            GLFWImage glfwImage = GLFWImage.malloc();
            glfwImage.set(w.get(0), h.get(0), image);
            GLFWImage gLFWImage = glfwImage;
            return gLFWImage;
        }
    }

    private static void updateWindowTitle(Minecraft mc) {
        String customTitle = CUSTOM_TITLE_PREFIX + mc.m_91094_().m_92546_();
        mc.m_91268_().m_85422_(customTitle);
    }
}

