/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.time.TimeUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

public class LocalTimeConverter
implements TypeConverter<LocalTime> {
    @Override
    public LocalTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalTime();
        }
        if (value instanceof Calendar) {
            return TimeUtil.fromCalendar((Calendar)value).toLocalTime();
        }
        if (value instanceof Timestamp) {
            return TimeUtil.fromMilliseconds(((Timestamp)value).getTime()).toLocalTime();
        }
        if (value instanceof Date) {
            return TimeUtil.fromDate((Date)value).toLocalTime();
        }
        if (value instanceof Number) {
            return TimeUtil.fromMilliseconds(((Number)value).longValue()).toLocalTime();
        }
        if (value instanceof LocalDate) {
            throw new TypeConversionException("Can't convert to time just from date: " + value);
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return LocalTime.parse(stringValue);
        }
        try {
            return TimeUtil.fromMilliseconds(Long.parseLong(stringValue)).toLocalTime();
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

