/*
 * Decompiled with CFR 0.152.
 */
package com.redstonia.redstoniaui.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class CustomFontLoader {
    private static Font russooneFont = null;
    private static final Map<Integer, GlyphCache> glyphCache = new HashMap<Integer, GlyphCache>();
    private static boolean fontLoaded = false;

    public static void loadFont() {
        if (fontLoaded) {
            return;
        }
        try {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            ResourceLocation fontLocation = new ResourceLocation("redstoniaui", "font/russoone.ttf");
            InputStream fontStream = ((Resource)resourceManager.m_213713_(fontLocation).orElseThrow(() -> new RuntimeException("Font not found: " + String.valueOf(fontLocation)))).m_215507_();
            russooneFont = Font.createFont(0, fontStream);
            fontStream.close();
            fontLoaded = true;
            System.out.println("[RedstoniaUI] Police russoone charg\u00e9e avec succ\u00e8s");
        }
        catch (Exception e) {
            System.err.println("[RedstoniaUI] Erreur lors du chargement de la police russoone: " + e.getMessage());
            e.printStackTrace();
            fontLoaded = false;
        }
    }

    public static boolean isFontLoaded() {
        return fontLoaded && russooneFont != null;
    }

    public static NativeImage renderText(String text, int size, int color) {
        if (!CustomFontLoader.isFontLoaded()) {
            return null;
        }
        try {
            Font font = russooneFont.deriveFont(0, size);
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
            int width = (int)Math.ceil(font.getStringBounds(text, frc).getWidth()) + 8;
            int height = (int)Math.ceil(font.getStringBounds(text, frc).getHeight()) + 8;
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, width, height);
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.setFont(font);
            FontMetrics metrics = g2d.getFontMetrics();
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int x = 4;
            int y = metrics.getAscent() + 4;
            g2d.setColor(new Color(0, 0, 0, 128));
            g2d.drawString(text, x + 2, y + 2);
            g2d.setColor(new Color(r, g, b, 255));
            g2d.drawString(text, x, y);
            g2d.dispose();
            NativeImage nativeImage = new NativeImage(width, height, true);
            for (int py = 0; py < height; ++py) {
                for (int px = 0; px < width; ++px) {
                    int argb = bufferedImage.getRGB(px, py);
                    int alpha = argb >> 24 & 0xFF;
                    int red = argb >> 16 & 0xFF;
                    int green = argb >> 8 & 0xFF;
                    int blue = argb & 0xFF;
                    int abgr = alpha << 24 | blue << 16 | green << 8 | red;
                    nativeImage.m_84988_(px, py, abgr);
                }
            }
            return nativeImage;
        }
        catch (Exception e) {
            System.err.println("[RedstoniaUI] Erreur lors du rendu du texte: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static int getTextWidth(String text, int size) {
        if (!CustomFontLoader.isFontLoaded()) {
            return 0;
        }
        try {
            Font font = russooneFont.deriveFont(0, size);
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
            return (int)font.getStringBounds(text, frc).getWidth();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getTextHeight(String text, int size) {
        if (!CustomFontLoader.isFontLoaded()) {
            return 0;
        }
        try {
            Font font = russooneFont.deriveFont(0, size);
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
            return (int)font.getStringBounds(text, frc).getHeight();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void cleanup() {
        glyphCache.clear();
        System.out.println("[RedstoniaUI] Cache de police nettoy\u00e9");
    }

    private static class GlyphCache {
        final int width;
        final int height;
        final NativeImage image;

        GlyphCache(int width, int height, NativeImage image) {
            this.width = width;
            this.height = height;
            this.image = image;
        }
    }
}

