/*
 * Decompiled with CFR 0.152.
 */
package com.redstonia.redstoniaui.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redstonia.redstoniaui.client.gui.CustomSettingsScreen;
import com.redstonia.redstoniaui.client.gui.RedstoNews;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CustomMainMenuScreen
extends Screen {
    private ResourceLocation playButton;
    private ResourceLocation shopButton;
    private ResourceLocation settingsButton;
    private ResourceLocation exitButton;
    private ResourceLocation redstoniaTitle;
    private ResourceLocation background;
    private ResourceLocation serverBackground;
    private ResourceLocation newsImage;
    private boolean newsLoaded = false;

    public CustomMainMenuScreen() {
        super((Component)Component.m_237113_((String)"Redstonia Main Menu"));
    }

    private ResourceLocation getTranslatedResourceLocation(String path) {
        try {
            String language = Minecraft.m_91087_().m_91102_().m_264236_().toLowerCase();
            String langCode = language.split("_")[0];
            return new ResourceLocation("redstoniaui", "textures/" + langCode + path);
        }
        catch (Exception e) {
            return new ResourceLocation("redstoniaui", "textures/en" + path);
        }
    }

    private void initializeResources() {
        if (this.playButton == null) {
            this.playButton = this.getTranslatedResourceLocation("/gui/buttons/play.png");
            this.shopButton = this.getTranslatedResourceLocation("/gui/buttons/shop.png");
            this.settingsButton = this.getTranslatedResourceLocation("/gui/buttons/settings.png");
            this.exitButton = this.getTranslatedResourceLocation("/gui/buttons/exit.png");
            this.redstoniaTitle = this.getTranslatedResourceLocation("/titles/redstonia_title.png");
            this.background = this.getTranslatedResourceLocation("/gui/background.png");
            this.serverBackground = this.getTranslatedResourceLocation("/gui/server-background.png");
        }
    }

    private void loadNewsAsync() {
        if (!this.newsLoaded) {
            this.newsLoaded = true;
            new Thread(() -> {
                try {
                    String languageCode = Minecraft.m_91087_().m_91102_().m_264236_().toLowerCase();
                    String baseUrl = "https://redstonia.com/storage/img/";
                    String newsUrl = baseUrl + (languageCode.startsWith("fr") ? "news-fr.png" : "news-en.png");
                    String noNewsUrl = baseUrl + (languageCode.startsWith("fr") ? "no-news-fr.png" : "no-news-en.png");
                    NativeImage buffer = RedstoNews.downloadFile(new URL(newsUrl));
                    if (buffer == null) {
                        buffer = RedstoNews.downloadFile(new URL(noNewsUrl));
                    }
                    if (buffer == null) {
                        buffer = new NativeImage(1, 1, true);
                    }
                    NativeImage finalBuffer = buffer;
                    Minecraft.m_91087_().execute(() -> {
                        this.newsImage = Minecraft.m_91087_().m_91097_().m_118490_("redsto_news", new DynamicTexture(finalBuffer));
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Minecraft.m_91087_().execute(() -> {
                        NativeImage emptyImage = new NativeImage(1, 1, true);
                        this.newsImage = Minecraft.m_91087_().m_91097_().m_118490_("redsto_news", new DynamicTexture(emptyImage));
                    });
                }
            }).start();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initializeResources();
        this.loadNewsAsync();
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonX = this.f_96543_ / 2 - 200;
        int buttonY = this.f_96544_ / 2 - 25;
        this.m_142416_((GuiEventListener)new ImageButton(2, buttonX, buttonY, this.playButton, this));
        this.m_142416_((GuiEventListener)new ImageButton(3, buttonX, buttonY + 25, this.shopButton, this));
        this.m_142416_((GuiEventListener)new ImageButton(4, buttonX, buttonY + 50, this.settingsButton, this));
        this.m_142416_((GuiEventListener)new ImageButton(1, buttonX, buttonY + 75, this.exitButton, this));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.blitAtOriginalSize(guiGraphics, this.background, 0, 0, this.f_96543_, this.f_96544_);
        this.drawServerBackground(guiGraphics);
        this.drawLogo(guiGraphics);
        if (this.newsImage != null) {
            this.drawNews(guiGraphics);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void drawLogo(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int logoWidth = 256;
        int logoHeight = 46;
        int logoX = this.f_96543_ / 2 - 70;
        int logoY = this.f_96544_ / 4 - 35;
        this.blitAtOriginalSize(guiGraphics, this.redstoniaTitle, logoX, logoY, logoWidth, logoHeight);
        RenderSystem.disableBlend();
    }

    public void drawServerBackground(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int bgWidth = 242;
        int bgHeight = 149;
        int bgX = this.f_96543_ / 2 - 50;
        int bgY = this.f_96544_ / 4 + 25;
        this.blitAtOriginalSize(guiGraphics, this.serverBackground, bgX, bgY, bgWidth, bgHeight);
        RenderSystem.disableBlend();
    }

    public void drawNews(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int x_background = this.f_96543_ / 2 - 50;
        int y_background = this.f_96544_ / 4 + 25;
        int w_background = 242;
        int h_background = 149;
        int w_image = 232;
        int h_image = 139;
        int x_image = x_background + 5;
        int y_image = y_background + 5;
        this.blitAtOriginalSize(guiGraphics, this.newsImage, x_image, y_image, 232, 139);
        RenderSystem.disableBlend();
    }

    public void blitAtOriginalSize(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static class ImageButton
    extends Button {
        private final int id;
        private final ResourceLocation image;
        private final Screen parentScreen;

        public ImageButton(int id, int x, int y, ResourceLocation image, Screen parentScreen) {
            super(x, y, 120, 20, (Component)Component.m_237119_(), button -> {
                Minecraft mc = Minecraft.m_91087_();
                if (id == 2) {
                    ServerData server = new ServerData("Redstonia", "51.38.36.109:25565", false);
                    ConnectScreen.m_278792_((Screen)parentScreen, (Minecraft)mc, (ServerAddress)ServerAddress.m_171864_((String)"51.38.36.109:25565"), (ServerData)server, (boolean)false);
                } else if (id == 3) {
                    try {
                        Util.m_137581_().m_137648_(new URI("https://redstonia.com/shop"));
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                } else if (id == 4) {
                    mc.m_91152_((Screen)new CustomSettingsScreen(parentScreen, mc.f_91066_));
                } else if (id == 1) {
                    Minecraft.m_91087_().m_91395_();
                }
            }, Button.f_252438_);
            this.id = id;
            this.image = image;
            this.parentScreen = parentScreen;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.f_93624_) {
                boolean isHovered = mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= this.m_252907_() && mouseY <= this.m_252907_() + this.f_93619_;
                ResourceLocation textureToDraw = isHovered ? this.getSelectedTexture() : this.image;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.m_280163_(textureToDraw, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                RenderSystem.disableBlend();
            }
        }

        private ResourceLocation getSelectedTexture() {
            String path = this.image.m_135815_();
            return new ResourceLocation("redstoniaui", path.replace(".png", "_selected.png"));
        }
    }
}

