/*
 * Decompiled with CFR 0.152.
 */
package com.redstonia.redstoniaui.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.redstonia.redstoniaui.client.CustomFontLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.loading.ForgeLoadingOverlay;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeLoadingOverlay.class}, remap=false, priority=10000)
public class SplashProgressMixin {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("redstoniaui", "textures/gui/bg.png");
    private static ResourceLocation loadingTextTexture = null;
    private static ResourceLocation helpTextTexture = null;
    private static double time = 0.0;
    private static String currentTitle = "";
    private static String lastRenderedTitle = "";
    private static String lastRenderedLoadingText = "";
    private static List<String> sentences = new ArrayList<String>();
    private static List<String> passed = new ArrayList<String>();
    private static int loadingTextWidth = 0;
    private static int loadingTextHeight = 0;
    private static int helpTextWidth = 0;
    private static int helpTextHeight = 0;
    private static boolean initialized = false;
    private static boolean hasBeenCalled = false;
    private static boolean loadingComplete = false;

    @Inject(method={"render"}, at={@At(value="HEAD")}, remap=false, cancellable=true, require=0)
    private void renderModernLoadingScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        try {
            if (!hasBeenCalled) {
                hasBeenCalled = true;
                System.out.println("[RedstoniaUI] SplashProgressMixin activ\u00e9 - Remplacement complet de l'\u00e9cran Forge");
            }
            if (!(loadingComplete || SplashProgressMixin.mc.f_91073_ == null && SplashProgressMixin.mc.f_91080_ == null)) {
                loadingComplete = true;
                SplashProgressMixin.cleanup();
                System.out.println("[RedstoniaUI] Chargement termin\u00e9 - Nettoyage effectu\u00e9");
            }
            if (loadingComplete) {
                return;
            }
            ci.cancel();
            int windowWidth = mc.m_91268_().m_85441_();
            int windowHeight = mc.m_91268_().m_85442_();
            double guiScale = mc.m_91268_().m_85449_();
            int screenWidth = (int)((double)windowWidth / guiScale);
            int screenHeight = (int)((double)windowHeight / guiScale);
            guiGraphics.m_280509_(0, 0, screenWidth, screenHeight, -16777216);
            if (!initialized) {
                SplashProgressMixin.initialize();
                initialized = true;
            }
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            SplashProgressMixin.drawLoadingScreen(guiGraphics, screenWidth, screenHeight);
            poseStack.m_85849_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Exception e) {
            System.err.println("[RedstoniaUI] Erreur dans le rendu de l'\u00e9cran de chargement: " + e.getMessage());
            e.printStackTrace();
            try {
                int windowWidth = mc.m_91268_().m_85441_();
                int windowHeight = mc.m_91268_().m_85442_();
                double guiScale = mc.m_91268_().m_85449_();
                int screenWidth = (int)((double)windowWidth / guiScale);
                int screenHeight = (int)((double)windowHeight / guiScale);
                guiGraphics.m_280509_(0, 0, screenWidth, screenHeight, -16777216);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ci.cancel();
        }
    }

    private static void initialize() {
        if (!sentences.isEmpty()) {
            return;
        }
        CustomFontLoader.loadFont();
        String lang = System.getProperty("user.language", "en");
        boolean isFrench = "fr".equals(lang);
        sentences.add(isFrench ? "Pour bien commencer, accepte l'invitation d\u2019un pays avec la commande /f join (pays)." : "To get started, accept a country's invitation using /f join (country).");
        sentences.add(isFrench ? "Besoin d\u2019aide ou d\u2019un renseignement ? Consulte le wiki : wiki.redstonia.com" : "Looking for help or details? Check the wiki at wiki.redstonia.com");
        sentences.add(isFrench ? "Bienvenue sur Redstonia ! Les nouveaux joueurs b\u00e9n\u00e9ficient de 48h de protection en jeu." : "Welcome to Redstonia! New players receive 48 hours of in-game protection.");
        sentences.add(isFrench ? "Gagne de l\u2019argent en vendant tes objets \u00e0 l\u2019H\u00f4tel des ventes avec /hdv." : "Earn money by selling your items in the Auction House with /hdv.");
        sentences.add(isFrench ? "Soutiens Redstonia en votant et r\u00e9cup\u00e8re des r\u00e9compenses gr\u00e2ce \u00e0 /vote !" : "Support Redstonia by voting and claim rewards using /vote!");
        sentences.add(isFrench ? "Pour te d\u00e9placer facilement sur le serveur, utilise la commande /warps." : "Use /warps to travel quickly across the server.");
        sentences.add(isFrench ? "Viens \u00e9changer avec la communaut\u00e9 sur le Discord : https://discord.gg/redstonia" : "Come chat with the community on Discord: https://discord.gg/redstonia");
        System.out.println("[RedstoniaUI] SplashProgressMixin initialis\u00e9 avec " + sentences.size() + " phrases");
    }

    private static void drawLoadingScreen(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        try {
            if (time % 300.0 == 0.0) {
                SplashProgressMixin.changeTitle();
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            SplashProgressMixin.drawBackgroundImage(guiGraphics, screenWidth, screenHeight);
            SplashProgressMixin.drawLoadingText(guiGraphics, screenWidth, screenHeight);
            SplashProgressMixin.drawHelpText(guiGraphics, screenWidth, screenHeight);
            SplashProgressMixin.resetOpenGL();
            time += 1.0;
        }
        catch (Exception e) {
            System.err.println("[RedstoniaUI] Erreur dans drawLoadingScreen: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void drawBackgroundImage(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        try {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280163_(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        }
        catch (Exception e) {
            System.err.println("[RedstoniaUI] Erreur lors du rendu du fond: " + e.getMessage());
            guiGraphics.m_280509_(0, 0, screenWidth, screenHeight, -16777216);
        }
    }

    private static void drawLoadingText(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        String lang = System.getProperty("user.language", "en");
        boolean isFrench = "fr".equals(lang);
        String loadingText = isFrench ? "CHARGEMENT..." : "LOADING...";
        int x = 12;
        int y = screenHeight - 60;
        if (CustomFontLoader.isFontLoaded()) {
            SplashProgressMixin.drawCustomFontText(guiGraphics, loadingText, x, y, 16, 0xFFFFFF, true);
        } else {
            SplashProgressMixin.drawLoadingTextStyled(guiGraphics, loadingText, x, y, 0xFFFFFF);
        }
    }

    private static void drawHelpText(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        if (currentTitle == null || currentTitle.isEmpty()) {
            return;
        }
        int x = 12;
        int y = screenHeight - 35;
        if (CustomFontLoader.isFontLoaded()) {
            SplashProgressMixin.drawCustomFontText(guiGraphics, currentTitle, x, y, 9, 0xAAAAAA, false);
        } else {
            SplashProgressMixin.drawRegularTextStyled(guiGraphics, currentTitle, x, y, 0xAAAAAA);
        }
    }

    private static void drawCustomFontText(GuiGraphics guiGraphics, String text, int x, int y, int fontSize, int color, boolean isLoading) {
        try {
            int height;
            NativeImage image;
            if (isLoading && !text.equals(lastRenderedLoadingText)) {
                image = CustomFontLoader.renderText(text, fontSize, color);
                if (image != null) {
                    if (loadingTextTexture != null) {
                        mc.m_91097_().m_118513_(loadingTextTexture);
                    }
                    dynamicTexture = new DynamicTexture(image);
                    loadingTextTexture = mc.m_91097_().m_118490_("redstoniaui_loading_text", dynamicTexture);
                    loadingTextWidth = image.m_84982_();
                    loadingTextHeight = image.m_85084_();
                    lastRenderedLoadingText = text;
                    System.out.println("[RedstoniaUI] Texture de chargement cr\u00e9\u00e9e: " + loadingTextWidth + "x" + loadingTextHeight);
                }
            } else if (!isLoading && !text.equals(lastRenderedTitle) && (image = CustomFontLoader.renderText(text, fontSize, color)) != null) {
                if (helpTextTexture != null) {
                    mc.m_91097_().m_118513_(helpTextTexture);
                }
                dynamicTexture = new DynamicTexture(image);
                helpTextTexture = mc.m_91097_().m_118490_("redstoniaui_help_text", dynamicTexture);
                helpTextWidth = image.m_84982_();
                helpTextHeight = image.m_85084_();
                lastRenderedTitle = text;
            }
            ResourceLocation textureToUse = isLoading ? loadingTextTexture : helpTextTexture;
            int width = isLoading ? loadingTextWidth : helpTextWidth;
            int n = height = isLoading ? loadingTextHeight : helpTextHeight;
            if (textureToUse != null && width > 0 && height > 0) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureToUse);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(textureToUse, x, y, 0.0f, 0.0f, width, height, width, height);
                RenderSystem.disableBlend();
            }
        }
        catch (Exception e) {
            System.err.println("[RedstoniaUI] Erreur lors du rendu du texte personnalis\u00e9: " + e.getMessage());
            e.printStackTrace();
            if (isLoading) {
                SplashProgressMixin.drawLoadingTextStyled(guiGraphics, text, x, y, color);
            }
            SplashProgressMixin.drawRegularTextStyled(guiGraphics, text, x, y, color);
        }
    }

    private static void drawLoadingTextStyled(GuiGraphics guiGraphics, String text, int x, int y, int color) {
        Font mcFont = SplashProgressMixin.mc.f_91062_;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        guiGraphics.m_280056_(mcFont, text, 2, 2, 0, false);
        guiGraphics.m_280056_(mcFont, text, 0, 0, color, false);
        poseStack.m_85849_();
    }

    private static void drawRegularTextStyled(GuiGraphics guiGraphics, String text, int x, int y, int color) {
        Font mcFont = SplashProgressMixin.mc.f_91062_;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(1.3f, 1.3f, 1.0f);
        guiGraphics.m_280056_(mcFont, text, 0, 0, color, false);
        poseStack.m_85849_();
    }

    private static void changeTitle() {
        if (sentences.isEmpty()) {
            return;
        }
        String newTitle = sentences.get(new Random().nextInt(sentences.size()));
        if (passed.contains(newTitle) && passed.size() < sentences.size()) {
            SplashProgressMixin.changeTitle();
        } else {
            currentTitle = newTitle;
            passed.add(newTitle);
            if (passed.size() >= sentences.size()) {
                passed.clear();
            }
        }
    }

    private static void resetOpenGL() {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void cleanup() {
        time = 0.0;
        passed.clear();
        currentTitle = "";
        lastRenderedTitle = "";
        lastRenderedLoadingText = "";
        if (loadingTextTexture != null) {
            mc.m_91097_().m_118513_(loadingTextTexture);
            loadingTextTexture = null;
        }
        if (helpTextTexture != null) {
            mc.m_91097_().m_118513_(helpTextTexture);
            helpTextTexture = null;
        }
        CustomFontLoader.cleanup();
        System.out.println("[RedstoniaUI] SplashProgressMixin nettoy\u00e9");
    }
}

