/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;

public class CharacterConverter
implements TypeConverter<Character> {
    @Override
    public Character convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Character.class) {
            return (Character)value;
        }
        if (value instanceof Number) {
            char c = (char)((Number)value).intValue();
            return Character.valueOf(c);
        }
        try {
            String s = value.toString();
            if (s.length() != 1) {
                if (!StringUtil.containsOnlyDigitsAndSigns(s = s.trim())) {
                    throw new TypeConversionException(value);
                }
                try {
                    char c = (char)Integer.parseInt(s);
                    return Character.valueOf(c);
                }
                catch (NumberFormatException nfex) {
                    throw new TypeConversionException(value, (Throwable)nfex);
                }
            }
            return Character.valueOf(s.charAt(0));
        }
        catch (IndexOutOfBoundsException ioobex) {
            throw new TypeConversionException(value, (Throwable)ioobex);
        }
    }
}

