/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.time.TimeUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

public class LocalDateConverter
implements TypeConverter<LocalDate> {
    @Override
    public LocalDate convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof Calendar) {
            return TimeUtil.fromCalendar((Calendar)value).toLocalDate();
        }
        if (value instanceof Timestamp) {
            return TimeUtil.fromMilliseconds(((Timestamp)value).getTime()).toLocalDate();
        }
        if (value instanceof Date) {
            return TimeUtil.fromDate((Date)value).toLocalDate();
        }
        if (value instanceof Number) {
            return TimeUtil.fromMilliseconds(((Number)value).longValue()).toLocalDate();
        }
        if (value instanceof LocalTime) {
            throw new TypeConversionException("Can't convert to date just from time: " + value);
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return LocalDate.parse(stringValue);
        }
        try {
            return TimeUtil.fromMilliseconds(Long.parseLong(stringValue)).toLocalDate();
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

