/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.time.JulianDate;
import com.hypherionmc.simplerpc.jodd.time.TimeUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;

public class SqlDateConverter
implements TypeConverter<java.sql.Date> {
    @Override
    public java.sql.Date convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return (java.sql.Date)value;
        }
        if (value instanceof Calendar) {
            return new java.sql.Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return new java.sql.Date(((Date)value).getTime());
        }
        if (value instanceof JulianDate) {
            return new java.sql.Date(((JulianDate)value).toMilliseconds());
        }
        if (value instanceof LocalDateTime) {
            return new java.sql.Date(TimeUtil.toMilliseconds((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return new java.sql.Date(TimeUtil.toMilliseconds((LocalDate)value));
        }
        if (value instanceof Number) {
            return new java.sql.Date(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            try {
                return java.sql.Date.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new java.sql.Date(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

