/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public interface StreamCodec<A, T> {
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        @Override
        public void encode(ByteBuf buffer, Byte value) {
            buffer.writeByte((int)value.byteValue());
        }

        @Override
        public Byte decode(ByteBuf buffer) {
            return buffer.readByte();
        }
    };
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        public void encode(ByteBuf buffer, Boolean value) {
            buffer.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean decode(ByteBuf buffer) {
            return buffer.readBoolean();
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public void encode(ByteBuf buffer, Integer value) {
            buffer.writeInt(value.intValue());
        }

        @Override
        public Integer decode(ByteBuf buffer) {
            return buffer.readInt();
        }
    };
    public static final StreamCodec<ByteBuf, Long> LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public void encode(ByteBuf buffer, Long value) {
            buffer.writeLong(value.longValue());
        }

        @Override
        public Long decode(ByteBuf buffer) {
            return buffer.readLong();
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        @Override
        public void encode(ByteBuf buffer, Float value) {
            buffer.writeFloat(value.floatValue());
        }

        @Override
        public Float decode(ByteBuf buffer) {
            return Float.valueOf(buffer.readFloat());
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        @Override
        public void encode(ByteBuf buffer, Double value) {
            buffer.writeDouble(value.doubleValue());
        }

        @Override
        public Double decode(ByteBuf buffer) {
            return buffer.readDouble();
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING = new StreamCodec<ByteBuf, String>(){

        @Override
        public void encode(ByteBuf buffer, String value) {
            buffer.writeInt(value.length());
            for (char c : value.toCharArray()) {
                buffer.writeChar((int)c);
            }
        }

        @Override
        public String decode(ByteBuf buffer) {
            int length = buffer.readInt();
            Object str = "";
            for (int i = 0; i < length; ++i) {
                str = (String)str + buffer.readChar();
            }
            return str;
        }
    };
    public static final StreamCodec<ByteBuf, UUID> UUID = new StreamCodec<ByteBuf, UUID>(){

        @Override
        public void encode(ByteBuf buffer, UUID value) {
            buffer.writeLong(value.getMostSignificantBits());
            buffer.writeLong(value.getLeastSignificantBits());
        }

        @Override
        public UUID decode(ByteBuf buffer) {
            return new UUID(buffer.readLong(), buffer.readLong());
        }
    };
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = new StreamCodec<ByteBuf, CompoundTag>(){

        @Override
        public void encode(ByteBuf buffer, CompoundTag value) {
            if (value == null) {
                buffer.writeByte(0);
            } else {
                try {
                    NbtIo.m_128941_((CompoundTag)value, (DataOutput)new ByteBufOutputStream(buffer));
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }
        }

        @Override
        public CompoundTag decode(ByteBuf buffer) {
            int i = buffer.readerIndex();
            byte b0 = buffer.readByte();
            if (b0 == 0) {
                return null;
            }
            buffer.readerIndex(i);
            try {
                return NbtIo.m_128934_((DataInput)new ByteBufInputStream(buffer), (NbtAccounter)new NbtAccounter(0x200000L));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
    };
    public static final StreamCodec<ByteBuf, BlockPos> BLOCK_POS = new StreamCodec<ByteBuf, BlockPos>(){

        @Override
        public void encode(ByteBuf buffer, BlockPos value) {
            buffer.writeLong(value.m_121878_());
        }

        @Override
        public BlockPos decode(ByteBuf buffer) {
            return BlockPos.m_122022_((long)buffer.readLong());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, FluidStack> FLUID_STACK = new StreamCodec<FriendlyByteBuf, FluidStack>(){

        @Override
        public void encode(FriendlyByteBuf buffer, FluidStack value) {
            buffer.writeFluidStack(value);
        }

        @Override
        public FluidStack decode(FriendlyByteBuf buffer) {
            return buffer.readFluidStack();
        }
    };
    public static final StreamCodec<FriendlyByteBuf, ItemStack> ITEM_STACK = new StreamCodec<FriendlyByteBuf, ItemStack>(){

        @Override
        public void encode(FriendlyByteBuf buffer, ItemStack value) {
            buffer.writeItemStack(value, false);
        }

        @Override
        public ItemStack decode(FriendlyByteBuf buffer) {
            return buffer.m_130267_();
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Block> BLOCK = new StreamCodec<FriendlyByteBuf, Block>(){

        @Override
        public void encode(FriendlyByteBuf buffer, Block value) {
            buffer.m_236818_((IdMap)Block.f_49791_, (Object)value.m_49966_());
        }

        @Override
        public Block decode(FriendlyByteBuf buffer) {
            return ((BlockState)buffer.m_236816_((IdMap)Block.f_49791_)).m_60734_();
        }
    };
    public static final StreamCodec<FriendlyByteBuf, BlockState> BLOCK_STATE = new StreamCodec<FriendlyByteBuf, BlockState>(){

        @Override
        public void encode(FriendlyByteBuf buffer, BlockState value) {
            buffer.m_236818_((IdMap)Block.f_49791_, (Object)value);
        }

        @Override
        public BlockState decode(FriendlyByteBuf buffer) {
            return (BlockState)buffer.m_236816_((IdMap)Block.f_49791_);
        }
    };
    public static final StreamCodec<ByteBuf, ResourceLocation> RESOURCE_LOCATION = new StreamCodec<ByteBuf, ResourceLocation>(){

        @Override
        public void encode(ByteBuf buffer, ResourceLocation value) {
            String str = value.toString();
            buffer.writeInt(str.length());
            for (char c : str.toCharArray()) {
                buffer.writeChar((int)c);
            }
        }

        @Override
        public ResourceLocation decode(ByteBuf buffer) {
            int length = buffer.readInt();
            Object str = "";
            for (int i = 0; i < length; ++i) {
                str = (String)str + buffer.readChar();
            }
            return new ResourceLocation((String)str);
        }
    };
    public static final StreamCodec<ByteBuf, Vec3> VEC3 = new StreamCodec<ByteBuf, Vec3>(){

        @Override
        public Vec3 decode(ByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        @Override
        public void encode(ByteBuf buffer, Vec3 value) {
            buffer.writeDouble(value.f_82479_);
            buffer.writeDouble(value.f_82480_);
            buffer.writeDouble(value.f_82481_);
        }
    };

    public void encode(A var1, T var2);

    public T decode(A var1);
}

