/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicSounds;

public interface IItemElectric {
    public static final String JOULES_STORED = "joules";
    public static final String JOULES_CAPACITY = "maximumcapacity";
    public static final String VOLTAGE = "voltage";
    public static final String RECEIVE_LIMIT = "receivelimit";
    public static final String EXTRACT_LIMIT = "extractlimit";
    public static final String CURRENT_BATTERY = "currentbattery";

    default public double getJoulesStored(ItemStack stack) {
        return stack.m_41784_().m_128459_(JOULES_STORED);
    }

    public static void setEnergyStored(ItemStack stack, double amount) {
        stack.m_41784_().m_128347_(JOULES_STORED, amount);
    }

    default public double getMaximumCapacity(ItemStack item) {
        CompoundTag tag = item.m_41784_();
        if (!tag.m_128441_(JOULES_CAPACITY)) {
            IItemElectric.setMaximumCapacity(item, this.getElectricProperties().capacity);
        }
        return tag.m_128459_(JOULES_CAPACITY);
    }

    public static void setMaximumCapacity(ItemStack item, double amt) {
        item.m_41784_().m_128347_(JOULES_CAPACITY, amt);
    }

    default public double getReceiveLimit(ItemStack item) {
        CompoundTag tag = item.m_41784_();
        if (!tag.m_128441_(RECEIVE_LIMIT)) {
            IItemElectric.setReceiveLimit(item, this.getElectricProperties().receive.getJoules());
        }
        return tag.m_128459_(RECEIVE_LIMIT);
    }

    public static void setReceiveLimit(ItemStack stack, double amount) {
        stack.m_41784_().m_128347_(RECEIVE_LIMIT, amount);
    }

    default public double getExtractLimit(ItemStack item) {
        CompoundTag tag = item.m_41784_();
        if (!tag.m_128441_(EXTRACT_LIMIT)) {
            IItemElectric.setExtractLimit(item, this.getElectricProperties().extract.getJoules());
        }
        return tag.m_128459_(EXTRACT_LIMIT);
    }

    public static void setExtractLimit(ItemStack stack, double amount) {
        stack.m_41784_().m_128347_(EXTRACT_LIMIT, amount);
    }

    default public boolean isEnergyStorageOnly() {
        return this.getElectricProperties().isEnergyStorageOnly;
    }

    default public boolean cannotHaveBatterySwapped() {
        return this.getElectricProperties().cannotHaveBatterySwapped;
    }

    default public TransferPack extractPower(ItemStack stack, double amount, boolean debug) {
        if (this.getJoulesStored(stack) <= 0.0) {
            return TransferPack.EMPTY;
        }
        double current = this.getJoulesStored(stack);
        double extracted = Math.min(current, Math.min(this.getExtractLimit(stack), amount));
        if (!debug) {
            IItemElectric.setEnergyStored(stack, current - extracted);
        }
        return TransferPack.joulesVoltage(extracted, this.getElectricProperties().extract.getVoltage());
    }

    default public TransferPack receivePower(ItemStack stack, TransferPack amount, boolean debug) {
        double current = this.getJoulesStored(stack);
        double received = Math.min(amount.getJoules(), this.getMaximumCapacity(stack) - current);
        if (!debug) {
            if (amount.getVoltage() == this.getElectricProperties().receive.getVoltage() || amount.getVoltage() == -1.0) {
                IItemElectric.setEnergyStored(stack, current + received);
            }
            if (amount.getVoltage() > this.getElectricProperties().receive.getVoltage()) {
                this.overVoltage(amount);
                return TransferPack.EMPTY;
            }
        }
        return TransferPack.joulesVoltage(received, amount.getVoltage());
    }

    default public void overVoltage(TransferPack attempt) {
    }

    default public void swapBatteryPackFirstItem(ItemStack tool, Player player) {
        IItemElectric electricItem = (IItemElectric)tool.m_41720_();
        if (electricItem.isEnergyStorageOnly() || electricItem.cannotHaveBatterySwapped()) {
            return;
        }
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            IItemElectric electric;
            Item item;
            ItemStack playerItem = inv.m_8020_(i).m_41777_();
            if (playerItem.m_41619_() || !((item = playerItem.m_41720_()) instanceof IItemElectric) || !(electric = (IItemElectric)item).isEnergyStorageOnly() || !(electric.getJoulesStored(playerItem) > 0.0) || electric.getElectricProperties().extract.getVoltage() != electricItem.getElectricProperties().extract.getVoltage() || electric.getElectricProperties().receive.getVoltage() != electricItem.getElectricProperties().receive.getVoltage()) continue;
            ItemStack currBattery = electricItem.getCurrentBattery(tool);
            if (currBattery.m_41619_()) {
                return;
            }
            double joulesStored = electricItem.getJoulesStored(tool);
            electricItem.setCurrentBattery(tool, playerItem);
            IItemElectric.setEnergyStored(tool, electric.getJoulesStored(playerItem));
            IItemElectric.setEnergyStored(currBattery, joulesStored);
            inv.m_6836_(i, ItemStack.f_41583_);
            for (int j = 0; j < inv.f_35974_.size(); ++j) {
                ItemStack item2 = inv.m_8020_(j);
                if (!item2.m_41619_()) continue;
                inv.m_6836_(j, currBattery);
                player.m_9236_().m_5594_(null, player.m_20097_(), (SoundEvent)VoltaicSounds.SOUND_BATTERY_SWAP.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
                return;
            }
            return;
        }
    }

    public static boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        IItemElectric electric;
        Item item;
        if (action == null || action == ClickAction.PRIMARY || other.m_41619_()) {
            return false;
        }
        if (((IItemElectric)stack.m_41720_()).cannotHaveBatterySwapped()) {
            return false;
        }
        if (!(other.m_41720_() instanceof IItemElectric) || (item = other.m_41720_()) instanceof IItemElectric && !(electric = (IItemElectric)item).isEnergyStorageOnly()) {
            return false;
        }
        IItemElectric thisElectric = (IItemElectric)stack.m_41720_();
        IItemElectric otherElectric = (IItemElectric)other.m_41720_();
        if (otherElectric.getJoulesStored(other) == 0.0 || otherElectric.getElectricProperties().receive.getVoltage() != thisElectric.getElectricProperties().receive.getVoltage() || thisElectric.getElectricProperties().extract.getVoltage() != otherElectric.getElectricProperties().extract.getVoltage()) {
            return false;
        }
        ItemStack currBattery = thisElectric.getCurrentBattery(stack);
        double joulesStored = thisElectric.getJoulesStored(stack);
        IItemElectric.setEnergyStored(currBattery, joulesStored);
        access.m_142104_(currBattery);
        IItemElectric.setEnergyStored(stack, otherElectric.getJoulesStored(other));
        thisElectric.setCurrentBattery(stack, other);
        player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)VoltaicSounds.SOUND_BATTERY_SWAP.get(), SoundSource.PLAYERS, 0.25f, 1.0f, false);
        return true;
    }

    default public ItemStack getCurrentBattery(ItemStack tool) {
        if (((IItemElectric)tool.m_41720_()).getDefaultStorageBattery() == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        CompoundTag tag = tool.m_41784_();
        if (!tag.m_128441_(CURRENT_BATTERY)) {
            this.setCurrentBattery(tool, new ItemStack((ItemLike)this.getDefaultStorageBattery()));
        }
        return ItemStack.m_41712_((CompoundTag)tag.m_128469_(CURRENT_BATTERY));
    }

    default public void setCurrentBattery(ItemStack tool, ItemStack battery) {
        CompoundTag tag = tool.m_41784_();
        tag.m_128473_(CURRENT_BATTERY);
        Item item = battery.m_41720_();
        if (item instanceof IItemElectric) {
            IItemElectric electric = (IItemElectric)item;
            IItemElectric.setMaximumCapacity(tool, electric.getMaximumCapacity(battery));
        } else {
            IItemElectric.setMaximumCapacity(tool, this.getMaximumCapacity(tool));
        }
        tag.m_128365_(CURRENT_BATTERY, (Tag)battery.m_41739_(new CompoundTag()));
    }

    public ElectricItemProperties getElectricProperties();

    public Item getDefaultStorageBattery();

    public static void addBatteryTooltip(ItemStack stack, Level context, List<Component> tooltip) {
        tooltip.add((Component)VoltaicTextUtils.tooltip("currbattery", ((IItemElectric)stack.m_41720_()).getCurrentBattery(stack).m_41611_().m_6881_().m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
    }
}

