/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.radiation;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voltaic.Voltaic;
import voltaic.api.radiation.util.IHazmatSuit;
import voltaic.api.radiation.util.IRadiationRecipient;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.settings.VoltaicConstants;
import voltaic.registers.VoltaicCapabilities;
import voltaic.registers.VoltaicEffects;

public class CapabilityRadiationRecipient
implements IRadiationRecipient,
ICapabilitySerializable<CompoundTag> {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final LazyOptional<IRadiationRecipient> lazyOptional = LazyOptional.of(() -> this);
    private double recieved = 0.0;
    private double recievedStrength = 0.0;
    private double prevRecieved = 0.0;
    private double prevRecievedStrength = 0.0;

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == null || cap != VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT) {
            return LazyOptional.empty();
        }
        return this.lazyOptional.cast();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("recieved", this.recieved);
        tag.m_128347_("recievedstrength", this.recievedStrength);
        tag.m_128347_("prevrecieved", this.prevRecieved);
        tag.m_128347_("prevrecievedstrength", this.prevRecievedStrength);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT == null) {
            return;
        }
        this.recieved = nbt.m_128459_("recieved");
        this.recievedStrength = nbt.m_128459_("recievedstrength");
        this.prevRecieved = nbt.m_128459_("prevrecieved");
        this.prevRecievedStrength = nbt.m_128459_("prevrecievedstrength");
    }

    @Override
    public void recieveRadiation(LivingEntity entity, double rads, double strength) {
        Player player;
        if (rads <= 0.0) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            this.recieved += rads;
            this.recievedStrength = strength;
            return;
        }
        if (entity.m_21023_((MobEffect)VoltaicEffects.RADIATION_RESISTANCE.get())) {
            if (rads <= VoltaicConstants.IODINE_RESISTANCE_THRESHHOLD) {
                this.recieved += rads;
                this.recievedStrength = strength;
                return;
            }
            rads *= VoltaicConstants.IODINE_RAD_REDUCTION;
        }
        int count = 0;
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = entity.m_6844_(slot);
            if (!(stack.m_41720_() instanceof IHazmatSuit)) continue;
            ++count;
            float damage = (float)(rads * (double)2.15f) / 2169.9976f;
            if (Voltaic.RANDOM.nextFloat() >= damage) continue;
            stack.m_41622_((int)Math.ceil(damage), entity, item -> {});
        }
        if (count < 4) {
            int amplitude = CapabilityRadiationRecipient.getAmplitudeFromRadiation(rads, strength);
            int time = CapabilityRadiationRecipient.getDurationFromRadiation(rads);
            if (entity.m_21023_((MobEffect)VoltaicEffects.RADIATION.get())) {
                MobEffectInstance instance = entity.m_21124_((MobEffect)VoltaicEffects.RADIATION.get());
                if (instance.m_19564_() > amplitude) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)VoltaicEffects.RADIATION.get(), time + instance.m_19557_(), instance.m_19564_(), false, true));
                } else {
                    entity.m_7292_(new MobEffectInstance((MobEffect)VoltaicEffects.RADIATION.get(), time + instance.m_19557_(), amplitude, false, true));
                }
            } else {
                entity.m_7292_(new MobEffectInstance((MobEffect)VoltaicEffects.RADIATION.get(), time, amplitude, false, true));
            }
        }
        this.recieved += rads;
        this.recievedStrength = strength;
    }

    @Override
    public RadioactiveObject getRecievedRadiation(LivingEntity entity) {
        return new RadioactiveObject(this.prevRecievedStrength, this.prevRecieved);
    }

    @Override
    public void tick(LivingEntity entity) {
        this.prevRecieved = this.recieved;
        this.prevRecievedStrength = this.recievedStrength;
        this.recieved = 0.0;
        this.recievedStrength = 0.0;
    }

    public static int getDurationFromRadiation(double radiation) {
        return (int)Math.max(20.0, radiation / 100.0 * 20.0);
    }

    public static int getAmplitudeFromRadiation(double radiation, double strength) {
        return (int)Math.min(40.0, radiation / 100.0 * strength);
    }
}

