/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.radiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.api.radiation.util.IRadiationManager;
import voltaic.api.radiation.util.IRadiationRecipient;
import voltaic.common.settings.VoltaicConstants;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

@Mod.EventBusSubscriber(modid="voltaic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationSystem {
    @SubscribeEvent
    public static void tickServer(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (level.m_5776_()) {
            return;
        }
        if (!VoltaicConstants.RADIATION_SYSTEM_ENABLED) {
            RadiationSystem.wipeAllSources(level);
            return;
        }
        IRadiationManager manager = (IRadiationManager)level.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        manager.tick(level);
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        if (!VoltaicConstants.RADIATION_SYSTEM_ENABLED || event.getEntity().m_9236_().m_5776_() || event.getEntity() == null) {
            return;
        }
        IRadiationRecipient capability = (IRadiationRecipient)event.getEntity().getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT).orElse((Object)CapabilityUtils.EMPTY_RADIATION_REPIPIENT);
        if (capability == CapabilityUtils.EMPTY_RADIATION_REPIPIENT) {
            return;
        }
        capability.tick(event.getEntity());
    }

    public static void addRadiationSource(Level world, SimpleRadiationSource source) {
        if (!VoltaicConstants.RADIATION_SYSTEM_ENABLED) {
            return;
        }
        if (source == null) {
            throw new UnsupportedOperationException("source cannot be null");
        }
        IRadiationManager manager = (IRadiationManager)world.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        manager.addRadiationSource(source, world);
    }

    public static void removeRadiationSource(Level world, BlockPos pos, boolean shouldLinger) {
        if (!VoltaicConstants.RADIATION_SYSTEM_ENABLED) {
            return;
        }
        if (pos == null) {
            throw new UnsupportedOperationException("position cannot be null");
        }
        IRadiationManager manager = (IRadiationManager)world.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        manager.removeRadiationSource(pos, shouldLinger, world);
    }

    public static List<BlockPos> getRadiationSources(Level world) {
        IRadiationManager manager = (IRadiationManager)world.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return Collections.emptyList();
        }
        HashSet<BlockPos> sources = new HashSet<BlockPos>();
        sources.addAll(manager.getPermanentLocations(world));
        sources.addAll(manager.getTemporaryLocations(world));
        sources.addAll(manager.getFadingLocations(world));
        return new ArrayList<BlockPos>(sources);
    }

    public static void addDisipation(Level world, double amount, AABB volume) {
        if (!VoltaicConstants.RADIATION_SYSTEM_ENABLED) {
            return;
        }
        IRadiationManager manager = (IRadiationManager)world.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        manager.setLocalizedDisipation(amount, volume, world);
    }

    public static void removeDisipation(Level world, AABB volume) {
        IRadiationManager manager = (IRadiationManager)world.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        manager.removeLocalizedDisipation(volume, world);
    }

    public static void wipeAllSources(Level world) {
        IRadiationManager manager = (IRadiationManager)world.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        manager.wipeAllSources(world);
    }
}

