/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.event;

import com.mojang.datafixers.util.Either;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.radiation.util.RadiationShielding;
import voltaic.common.reloadlistener.RadiationShieldingRegister;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.utilities.VoltaicTextUtils;

@Mod.EventBusSubscriber(modid="voltaic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationTooltipHandler {
    @SubscribeEvent
    public static void renderTooltip(RenderTooltipEvent.GatherComponents event) {
        if (Screen.m_96638_()) {
            ItemStack stack = event.getItemStack();
            if (stack.m_41619_()) {
                return;
            }
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                RadiationShielding shielding = RadiationShieldingRegister.getValue(blockItem.m_40614_());
                if (shielding.amount() <= 0.0) {
                    return;
                }
                event.getTooltipElements().add(Either.left((Object)VoltaicTextUtils.tooltip("radiationshieldingamount", ChatFormatter.getChatDisplayShort(shielding.amount(), DisplayUnits.RAD).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY)));
            }
        } else if (Screen.m_96637_() && !event.getItemStack().m_41619_()) {
            event.getTooltipElements().add(Either.left((Object)ChatFormatter.getChatDisplayShort(RadioactiveItemRegister.getValue(event.getItemStack().m_41720_()).amount(), DisplayUnits.RAD).m_130940_(ChatFormatting.YELLOW)));
        }
    }
}

