/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.render.shader;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterShadersEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import voltaic.Voltaic;

public class VoltaicShaders
extends RenderType {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Electrodynamics: Shaders");
    private static Uniform uniformAlphaCutoff;
    private static final ResourceLocation GREATER_ALPHA_LOC;
    public static final RenderType GREATER_ALPHA;

    public static void onRegisterShaders(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), GREATER_ALPHA_LOC, DefaultVertexFormat.f_85820_), shader -> {
                uniformAlphaCutoff = shader.m_173348_("AlphaCutoff");
            });
        }
        catch (IOException err) {
            LOGGER.warn(err.getMessage());
        }
    }

    public static RenderType getRenderTypeAlphaCutoff(float cutoff) {
        VoltaicShaders.setRenderTypeAlphaCutoff(cutoff);
        return GREATER_ALPHA;
    }

    public static void setRenderTypeAlphaCutoff(float cutoff) {
        uniformAlphaCutoff.m_5985_(Math.min(cutoff, 1.0f));
    }

    private VoltaicShaders(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
        super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        throw new UnsupportedOperationException("No");
    }

    static {
        GREATER_ALPHA_LOC = Voltaic.rl("plasmaorb");
        GREATER_ALPHA = RenderType.m_173215_((String)GREATER_ALPHA_LOC.toString(), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(f_110152_).m_173292_(f_173073_).m_173290_(f_110147_).m_110685_(RenderStateShard.f_110139_).m_110691_(false));
    }
}

