/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.block.connect;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import voltaic.common.block.connect.BlockScaffold;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.block.GenericEntityBlockWaterloggable;
import voltaic.prefab.tile.types.GenericConnectTile;

public abstract class AbstractConnectBlock
extends GenericEntityBlockWaterloggable {
    protected final VoxelShape[] boundingBoxes = new VoxelShape[7];
    int maxValue = 64;
    protected VoxelShape[] shapestates = new VoxelShape[this.maxValue];

    public AbstractConnectBlock(BlockBehaviour.Properties properties, double radius) {
        super(properties);
        this.generateBoundingBoxes(radius);
        ((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VoltaicBlockStates.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false));
    }

    public void generateBoundingBoxes(double radius) {
        double w = radius;
        double sm = 8.0 - w;
        double lg = 8.0 + w;
        this.boundingBoxes[0] = Block.m_49796_((double)sm, (double)0.0, (double)sm, (double)lg, (double)lg, (double)lg);
        this.boundingBoxes[1] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)16.0, (double)lg);
        this.boundingBoxes[2] = Block.m_49796_((double)sm, (double)sm, (double)0.0, (double)lg, (double)lg, (double)lg);
        this.boundingBoxes[3] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)16.0);
        this.boundingBoxes[4] = Block.m_49796_((double)0.0, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
        this.boundingBoxes[5] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)16.0, (double)lg, (double)lg);
        this.boundingBoxes[6] = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BlockEntity entity;
        BlockEntity blockEntity;
        VoxelShape camoShape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)).booleanValue() && (blockEntity = worldIn.m_7702_(pos)) instanceof GenericConnectTile) {
            GenericConnectTile connect = (GenericConnectTile)blockEntity;
            camoShape = connect.isCamoAir() ? connect.getScaffoldBlock().m_60651_(worldIn, pos, context) : connect.getCamoBlock().m_60651_(worldIn, pos, context);
        }
        if (!((entity = worldIn.m_7702_(pos)) instanceof GenericConnectTile)) {
            return Shapes.m_83040_();
        }
        EnumConnectType[] connections = ((GenericConnectTile)entity).readConnections();
        int hash = AbstractConnectBlock.hashPresentSides(connections);
        if (this.shapestates[hash] != null) {
            return AbstractConnectBlock.getCamoShape(this.shapestates[hash], camoShape);
        }
        VoxelShape shape = this.boundingBoxes[6];
        for (int i = 0; i < 6; ++i) {
            if (connections[i] == EnumConnectType.NONE) continue;
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.boundingBoxes[i], (BooleanOp)BooleanOp.f_82695_);
        }
        this.shapestates[hash] = shape;
        if (shape == null) {
            return Shapes.m_83040_();
        }
        return AbstractConnectBlock.getCamoShape(shape, camoShape);
    }

    private static VoxelShape getCamoShape(VoxelShape wireShape, VoxelShape camoShape) {
        if (camoShape == Shapes.m_83040_()) {
            return wireShape;
        }
        if (camoShape == Shapes.m_83144_()) {
            return camoShape;
        }
        return Shapes.m_83113_((VoxelShape)wireShape, (VoxelShape)camoShape, (BooleanOp)BooleanOp.f_82695_);
    }

    public static int hashPresentSides(EnumConnectType[] connections) {
        int flag = 0;
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            if (connections[i] == EnumConnectType.NONE) continue;
            flag |= 1 << i;
        }
        return flag;
    }

    @Override
    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VoltaicBlockStates.HAS_SCAFFOLDING});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (level.m_8055_(pos).m_60734_() instanceof BlockScaffold) {
            return true;
        }
        return super.m_7898_(state, level, pos);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState superState = super.m_5573_(context);
        Level world = context.m_43723_().m_9236_();
        boolean set = false;
        if (world.m_8055_(context.m_8083_()).m_60734_() instanceof BlockScaffold) {
            superState = (BlockState)superState.m_61124_((Property)VoltaicBlockStates.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(true));
            set = true;
        } else {
            superState = (BlockState)superState.m_61124_((Property)VoltaicBlockStates.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false));
        }
        if (!world.m_5776_() && set) {
            world.m_46597_(context.m_8083_(), Blocks.f_50016_.m_49966_());
        }
        return superState;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41619_()) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockitem = (BlockItem)item;
            item = worldIn.m_7702_(pos);
            if (item instanceof GenericConnectTile) {
                GenericConnectTile connect = (GenericConnectTile)item;
                BlockPlaceContext newCtx = new BlockPlaceContext(player, handIn, stack, hit);
                Block block = blockitem.m_40614_();
                if (block instanceof BlockScaffold) {
                    BlockScaffold scaffold = (BlockScaffold)block;
                    if (!((Boolean)state.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)).booleanValue()) {
                        if (!worldIn.f_46443_) {
                            if (!player.m_7500_()) {
                                stack.m_41774_(1);
                                player.m_21008_(handIn, stack);
                            }
                            state = (BlockState)state.m_61124_((Property)VoltaicBlockStates.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(true));
                            worldIn.m_46597_(pos, state);
                            connect.setScaffoldBlock(scaffold.m_5573_(newCtx));
                            worldIn.m_5594_(null, pos, blockitem.m_40614_().m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        return InteractionResult.CONSUME;
                    }
                } else if (!(blockitem.m_40614_() instanceof AbstractConnectBlock) && ((Boolean)state.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)).booleanValue()) {
                    if (connect.isCamoAir()) {
                        if (!worldIn.f_46443_) {
                            connect.setCamoBlock(blockitem.m_40614_().m_5573_(newCtx));
                            if (!player.m_7500_()) {
                                stack.m_41774_(1);
                                player.m_21008_(handIn, stack);
                            }
                            worldIn.m_5594_(null, pos, blockitem.m_40614_().m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            worldIn.m_7726_().m_7827_().m_7174_(pos);
                        }
                        return InteractionResult.CONSUME;
                    }
                    if (!connect.getCamoBlock().m_60713_(blockitem.m_40614_())) {
                        if (!worldIn.f_46443_) {
                            if (!player.m_7500_()) {
                                if (!player.m_36356_(new ItemStack((ItemLike)connect.getCamoBlock().m_60734_()))) {
                                    worldIn.m_7967_((Entity)new ItemEntity(player.m_9236_(), (double)((int)player.m_20185_()), (double)((int)player.m_20186_()), (double)((int)player.m_20189_()), new ItemStack((ItemLike)connect.getCamoBlock().m_60734_())));
                                }
                                stack.m_41774_(1);
                                player.m_21008_(handIn, stack);
                            }
                            connect.setCamoBlock(blockitem.m_40614_().m_5573_(newCtx));
                            worldIn.m_5594_(null, pos, blockitem.m_40614_().m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        return InteractionResult.CONSUME;
                    }
                }
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_49635_(state, builder));
        if (((Boolean)state.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)).booleanValue() && (object = builder.m_287159_(LootContextParams.f_81462_)) instanceof GenericConnectTile) {
            GenericConnectTile connect = (GenericConnectTile)object;
            drops.add(new ItemStack((ItemLike)connect.getScaffoldBlock().m_60734_()));
            if (!connect.isCamoAir()) {
                drops.add(new ItemStack((ItemLike)connect.getCamoBlock().m_60734_()));
            }
        }
        return drops;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        if (!((Boolean)state.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)).booleanValue()) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericConnectTile) {
            GenericConnectTile connect = (GenericConnectTile)blockEntity;
            if (connect.isCamoAir()) {
                return connect.getScaffoldBlock().m_60631_(level, pos);
            }
            return connect.getCamoBlock().m_60631_(level, pos);
        }
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (!((Boolean)state.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)).booleanValue()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericConnectTile) {
            GenericConnectTile connect = (GenericConnectTile)blockEntity;
            if (connect.isCamoAir()) {
                return connect.getScaffoldBlock().m_60734_().getLightEmission(connect.getScaffoldBlock(), level, pos);
            }
            return connect.getCamoBlock().m_60734_().getLightEmission(connect.getCamoBlock(), level, pos);
        }
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.m_61143_((Property)VoltaicBlockStates.HAS_SCAFFOLDING)).booleanValue()) {
            return super.m_5909_(state, level, pos, context);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericConnectTile) {
            GenericConnectTile connect = (GenericConnectTile)blockEntity;
            if (connect.isCamoAir()) {
                return connect.getScaffoldBlock().m_60771_(level, pos, context);
            }
            return connect.getCamoBlock().m_60771_(level, pos, context);
        }
        return super.m_5909_(state, level, pos, context);
    }

    @Override
    public void onRotate(ItemStack stack, BlockPos pos, Player player) {
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericConnectTile) {
            GenericConnectTile connect = (GenericConnectTile)blockEntity;
            if (!connect.isCamoAir()) {
                Block camo = connect.getCamoBlock().m_60734_();
                connect.setCamoBlock(Blocks.f_50016_.m_49966_());
                if (!player.m_7500_() && !player.m_36356_(new ItemStack((ItemLike)camo))) {
                    level.m_7967_((Entity)new ItemEntity(player.m_9236_(), (double)((int)player.m_20185_()), (double)((int)player.m_20186_()), (double)((int)player.m_20189_()), new ItemStack((ItemLike)camo)));
                }
                return;
            }
            if (!connect.isScaffoldAir()) {
                Block scaffold = connect.getScaffoldBlock().m_60734_();
                connect.setScaffoldBlock(Blocks.f_50016_.m_49966_());
                level.m_46597_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)VoltaicBlockStates.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false)));
                if (!player.m_7500_() && !player.m_36356_(new ItemStack((ItemLike)scaffold))) {
                    level.m_7967_((Entity)new ItemEntity(player.m_9236_(), (double)((int)player.m_20185_()), (double)((int)player.m_20186_()), (double)((int)player.m_20189_()), new ItemStack((ItemLike)scaffold)));
                }
                return;
            }
        }
        super.onRotate(stack, pos, player);
    }
}

