/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.block.voxelshapes;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeProvider {
    private final VoxelShape omni;
    private final VoxelShape[] shapes;
    public static final VoxelShapeProvider DEFAULT = new VoxelShapeProvider(Shapes.m_83144_(), null);
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    private VoxelShapeProvider(VoxelShape omni, VoxelShape[] shapes) {
        this.omni = omni;
        this.shapes = shapes;
    }

    public VoxelShape getShape(@Nullable Direction dir) {
        if (this.omni != null) {
            return this.omni;
        }
        if (dir == Direction.UP || dir == Direction.DOWN) {
            return Shapes.m_83144_();
        }
        return this.shapes[dir.ordinal()];
    }

    public static VoxelShapeProvider createOmni(VoxelShape shape) {
        return new VoxelShapeProvider(shape, null);
    }

    public static VoxelShapeProvider createDirectional(Direction startDirection, VoxelShape shape) {
        return new VoxelShapeProvider(null, VoxelShapeProvider.createShapes(shape, startDirection));
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static VoxelShape[] createShapes(VoxelShape baseShape, Direction baseDirection) {
        VoxelShape[] shapes = new VoxelShape[6];
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            shapes[dir.ordinal()] = VoxelShapeProvider.rotateShape(baseDirection, dir, baseShape);
        }
        return shapes;
    }
}

