/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.fluiditem2gas;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import voltaic.api.gas.GasStack;
import voltaic.common.recipe.recipeutils.AbstractMaterialRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentProcessor;

public abstract class FluidItem2GasRecipe
extends AbstractMaterialRecipe {
    private List<FluidIngredient> fluidIngredients;
    private List<CountableIngredient> ingredients;
    private GasStack outputStack;

    public FluidItem2GasRecipe(ResourceLocation group, List<CountableIngredient> inputItems, List<FluidIngredient> inputFluids, GasStack outputGas, double experience, int ticks, double usagePerTick, List<ProbableItem> itemBiproducts, List<ProbableFluid> fluidBiproducts, List<ProbableGas> gasBiproducts) {
        super(group, experience, ticks, usagePerTick, itemBiproducts, fluidBiproducts, gasBiproducts);
        this.ingredients = inputItems;
        this.fluidIngredients = inputFluids;
        this.outputStack = outputGas;
    }

    @Override
    public boolean matchesRecipe(ComponentProcessor pr, int procNumber) {
        Pair<List<Integer>, Boolean> fluidPair;
        Pair<List<Integer>, Boolean> itemPair = FluidItem2GasRecipe.areItemsValid(this.getCountedIngredients(), ((ComponentInventory)pr.getHolder().getComponent(IComponentType.Inventory)).getInputsForProcessor(procNumber));
        if (((Boolean)itemPair.getSecond()).booleanValue() && ((Boolean)(fluidPair = FluidItem2GasRecipe.areFluidsValid(this.getFluidIngredients(), ((ComponentFluidHandlerMulti)pr.getHolder().getComponent(IComponentType.FluidHandler)).getInputTanks())).getSecond()).booleanValue()) {
            this.setItemArrangement(procNumber, (List)itemPair.getFirst());
            this.setFluidArrangement((List)fluidPair.getFirst());
            return true;
        }
        return false;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    @Override
    public GasStack getGasRecipeOutput() {
        return this.outputStack;
    }

    public List<CountableIngredient> getCountedIngredients() {
        return this.ingredients;
    }

    public static interface Factory<T extends FluidItem2GasRecipe> {
        public T create(ResourceLocation var1, List<CountableIngredient> var2, List<FluidIngredient> var3, GasStack var4, double var5, int var7, double var8, List<ProbableItem> var10, List<ProbableFluid> var11, List<ProbableGas> var12);
    }
}

