/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.client;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.ObjModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import voltaic.Voltaic;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.datagen.utils.client.model.WireModelBuilder;

public abstract class BaseBlockstateProvider
extends BlockStateProvider {
    public final String modID;

    public BaseBlockstateProvider(PackOutput output, ExistingFileHelper exFileHelper, String modID) {
        super(output, modID, exFileHelper);
        this.modID = modID;
    }

    public ItemModelBuilder simpleBlock(RegistryObject<? extends Block> block, ModelFile file, boolean registerItem) {
        return this.simpleBlock((Block)block.get(), file, registerItem);
    }

    public ItemModelBuilder simpleBlock(Block block, ModelFile file, boolean registerItem) {
        this.simpleBlock(block, file);
        if (registerItem) {
            return this.blockItem(block, file);
        }
        return null;
    }

    public ItemModelBuilder simpleBlock(RegistryObject<? extends Block> block, ResourceLocation texture, boolean registerItem) {
        return this.simpleBlock((Block)block.get(), texture, registerItem);
    }

    public ItemModelBuilder simpleBlock(Block block, ResourceLocation texture, boolean registerItem) {
        return this.simpleBlock(block, (ModelFile)this.models().cubeAll(this.name(block), texture), registerItem);
    }

    public ItemModelBuilder glassBlock(RegistryObject<? extends Block> block, ResourceLocation texture, boolean registerItem) {
        return this.glassBlock((Block)block.get(), texture, registerItem);
    }

    public ItemModelBuilder glassBlock(Block block, ResourceLocation texture, boolean registerItem) {
        return this.simpleBlockCustomRenderType(block, texture, Voltaic.vanillarl("cutout"), registerItem);
    }

    public ItemModelBuilder simpleBlockCustomRenderType(Block block, ResourceLocation texture, ResourceLocation renderType, boolean registerItem) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeAll(this.name(block), texture)).renderType(renderType);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
        if (registerItem) {
            return this.blockItem(block, (ModelFile)builder);
        }
        return null;
    }

    public ItemModelBuilder simpleBlockCustomRenderType(RegistryObject<? extends Block> block, ResourceLocation texture, ResourceLocation renderType, boolean registerItem) {
        return this.simpleBlockCustomRenderType((Block)block.get(), texture, renderType, registerItem);
    }

    public ItemModelBuilder airBlock(RegistryObject<? extends Block> block, String particleTexture, boolean registerItem) {
        return this.airBlock((Block)block.get(), particleTexture, registerItem);
    }

    public ItemModelBuilder airBlock(Block block, String particleTexture, boolean registerItem) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", this.modLoc(particleTexture))).renderType("cutout");
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
        if (registerItem) {
            return this.blockItem(block, (ModelFile)builder);
        }
        return null;
    }

    public ItemModelBuilder bottomSlabBlock(RegistryObject<? extends Block> block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top, boolean registerItem) {
        return this.bottomSlabBlock((Block)block.get(), side, bottom, top, registerItem);
    }

    public ItemModelBuilder bottomSlabBlock(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top, boolean registerItem) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().slab(this.name(block), side, bottom, top);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
        if (registerItem) {
            return this.blockItem(block, (ModelFile)builder);
        }
        return null;
    }

    public ItemModelBuilder horrRotatedBlock(RegistryObject<? extends Block> block, ModelFile modelFile, boolean registerItem) {
        return this.horrRotatedBlock(block, modelFile, 0, 0, registerItem);
    }

    public ItemModelBuilder horrRotatedBlock(RegistryObject<? extends Block> block, ModelFile modelFile, int yRotationOffset, int xRotation, boolean registerItem) {
        return this.horrRotatedBlock((Block)block.get(), modelFile, yRotationOffset, xRotation, registerItem);
    }

    public ItemModelBuilder horrRotatedBlock(Block block, ModelFile file, boolean registerItem) {
        return this.horrRotatedBlock(block, file, 0, 0, registerItem);
    }

    public ItemModelBuilder horrRotatedBlock(Block block, ModelFile file, int yRotationOffset, int xRotation, boolean registerItem) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).modelForState().modelFile(file).rotationY((270 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).modelForState().modelFile(file).rotationY((0 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile(file).rotationY((90 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).modelForState().modelFile(file).rotationY((180 + yRotationOffset) % 360).rotationX(xRotation).addModel();
        if (registerItem) {
            return this.blockItem(block, file);
        }
        return null;
    }

    public ItemModelBuilder horrRotatedLitBlock(RegistryObject<? extends Block> block, ModelFile off, ModelFile on, boolean registerItem) {
        return this.horrRotatedLitBlock(block, off, on, 0, 0, registerItem);
    }

    public ItemModelBuilder horrRotatedLitBlock(RegistryObject<? extends Block> block, ModelFile off, ModelFile on, int yRotationOffset, int xRotation, boolean registerItem) {
        return this.horrRotatedLitBlock((Block)block.get(), off, on, yRotationOffset, xRotation, registerItem);
    }

    public ItemModelBuilder horrRotatedLitBlock(Block block, ModelFile off, ModelFile on, boolean registerItem) {
        return this.horrRotatedLitBlock(block, off, on, 0, 0, registerItem);
    }

    public ItemModelBuilder horrRotatedLitBlock(Block block, ModelFile off, ModelFile on, int yRotationOffset, int xRotation, boolean registerItem) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).rotationY((270 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).rotationY((0 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).rotationY((90 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).rotationY((180 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).rotationY((270 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.EAST).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).rotationY((0 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.SOUTH).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).rotationY((90 + yRotationOffset) % 360).rotationX(xRotation).addModel()).partialState().with((Property)VoltaicBlockStates.FACING, (Comparable)Direction.WEST).with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).rotationY((180 + yRotationOffset) % 360).rotationX(xRotation).addModel();
        if (registerItem) {
            return this.blockItem(block, off);
        }
        return null;
    }

    public ItemModelBuilder redstoneToggleBlock(RegistryObject<? extends Block> block, ModelFile off, ModelFile on, boolean registerItem) {
        return this.redstoneToggleBlock((Block)block.get(), off, on, registerItem);
    }

    public ItemModelBuilder redstoneToggleBlock(Block block, ModelFile off, ModelFile on, boolean registerItem) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).addModel()).partialState().with((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).addModel();
        if (registerItem) {
            return this.blockItem(block, off);
        }
        return null;
    }

    public void wire(Block block, ModelFile none, ModelFile side, boolean registerItem) {
        ModelBuilder model = ((BlockModelBuilder)((WireModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), Voltaic.vanillarl("cube"))).customLoader(WireModelBuilder::begin)).models(none, side, side).end()).renderType(Voltaic.vanillarl("cutout"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        if (registerItem) {
            this.simpleBlockItem(block, none);
        }
    }

    public ItemModelBuilder snowyBlock(Block block, ModelFile noSnow, ModelFile withSnow, boolean registerItem) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(noSnow).addModel()).partialState().with((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(withSnow).rotationY(0).addModel();
        if (registerItem) {
            return this.blockItem(block, noSnow);
        }
        return null;
    }

    public ItemModelBuilder pressurePlateBlock(PressurePlateBlock block, ResourceLocation texture, @Nullable ResourceLocation renderType, boolean registerItem) {
        ModelBuilder pressurePlate = this.models().pressurePlate(this.name((Block)block), texture);
        ModelBuilder pressurePlateDown = this.models().pressurePlateDown(this.name((Block)block) + "_down", texture);
        if (renderType != null) {
            pressurePlate = ((BlockModelBuilder)this.models().pressurePlate(this.name((Block)block), texture)).renderType(renderType);
            pressurePlateDown = ((BlockModelBuilder)this.models().pressurePlateDown(this.name((Block)block) + "_down", texture)).renderType(renderType);
        }
        return this.pressurePlateBlock(block, (ModelFile)pressurePlate, (ModelFile)pressurePlateDown, renderType, registerItem);
    }

    public ItemModelBuilder pressurePlateBlock(PressurePlateBlock block, ModelFile pressurePlate, ModelFile pressurePlateDown, @Nullable ResourceLocation renderType, boolean registerItem) {
        this.getVariantBuilder((Block)block).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(pressurePlateDown)}).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(pressurePlate)});
        if (registerItem) {
            return this.blockItem((Block)block, pressurePlate);
        }
        return null;
    }

    public ItemModelBuilder simpleColumnBlock(Block block, ResourceLocation side, ResourceLocation top, boolean registerItem) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().cubeColumn(this.name(block), side, top);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
        if (registerItem) {
            return this.blockItem(block, (ModelFile)builder);
        }
        return null;
    }

    public ItemModelBuilder crossBlock(RegistryObject<? extends Block> block, ResourceLocation texture, @Nullable ResourceLocation renderType, boolean registerItem) {
        return this.crossBlock((Block)block.get(), texture, renderType, registerItem);
    }

    public ItemModelBuilder crossBlock(Block block, ResourceLocation texture, @Nullable ResourceLocation renderType, boolean registerItem) {
        ModelBuilder cross = renderType == null ? this.models().cross(this.name(block), texture) : ((BlockModelBuilder)this.models().cross(this.name(block), texture)).renderType(renderType);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)cross)});
        if (registerItem) {
            return this.blockItem(block, (ModelFile)cross);
        }
        return null;
    }

    public BlockModelBuilder getObjModel(String name, String modelLoc) {
        return (BlockModelBuilder)((ObjModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name, "cube")).customLoader(ObjModelBuilder::begin)).flipV(true).modelLocation(this.modLoc("models/" + modelLoc + ".obj")).end();
    }

    public BlockModelBuilder blockTopBottom(RegistryObject<? extends Block> block, String top, String bottom, String side) {
        return (BlockModelBuilder)this.models().cubeBottomTop(BuiltInRegistries.f_256975_.m_7981_((Object)((Block)block.get())).m_135815_(), new ResourceLocation(this.modID, side), new ResourceLocation(this.modID, bottom), new ResourceLocation(this.modID, top));
    }

    public ItemModelBuilder blockItem(Block block, ModelFile model) {
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).m_135815_())).parent(model);
    }

    public ResourceLocation key(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    public String name(Block block) {
        return this.key(block).m_135815_();
    }

    public ModelFile.ExistingModelFile existingBlock(RegistryObject<? extends Block> block) {
        return this.existingBlock(block.getId());
    }

    public ModelFile.ExistingModelFile existingBlock(Block block) {
        return this.existingBlock(BuiltInRegistries.f_256975_.m_7981_((Object)block));
    }

    public ModelFile.ExistingModelFile existingBlock(ResourceLocation loc) {
        return this.models().getExistingFile(loc);
    }

    public ResourceLocation blockLoc(String texture) {
        return this.modLoc("block/" + texture);
    }

    public ResourceLocation modelLoc(String texture) {
        return this.modLoc("model/" + texture);
    }
}

