/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.loottable;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class AbstractLootTableProvider
extends VanillaBlockLoot {
    private final String modID;

    public AbstractLootTableProvider(String modID) {
        this.modID = modID;
    }

    public LootTable.Builder machineTable(String name, Block block, BlockEntityType<?> type, boolean items, boolean fluids, boolean gases, boolean energy, boolean additional) {
        CopyNbtFunction.Builder function = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        if (items) {
            function = function.m_80282_("Items", "BlockEntityTag", CopyNbtFunction.MergeStrategy.REPLACE);
            function = function.m_80282_("itemproperty_size", "BlockEntityTag", CopyNbtFunction.MergeStrategy.REPLACE);
        }
        if (fluids) {
            function = function.m_80282_("fluid", "BlockEntityTag", CopyNbtFunction.MergeStrategy.REPLACE);
        }
        if (gases) {
            // empty if block
        }
        if (energy) {
            function = function.m_80282_("joules", "BlockEntityTag.joules", CopyNbtFunction.MergeStrategy.REPLACE);
        }
        if (additional) {
            function = function.m_80282_("additional", "BlockEntityTag.additional", CopyNbtFunction.MergeStrategy.REPLACE);
        }
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)function).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(type).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTouchAndFortuneTable(String name, Block block, Item lootItem, float min, float max) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_(f_243678_), LootItem.m_79579_((ItemLike)lootItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTouchOnlyTable(String name, Block block) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_(f_243678_));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSimpleBlockTable(String name, Block block) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.f_256975_.m_6579_().stream().filter(e -> ((ResourceKey)e.getKey()).m_135782_().m_135827_().equals(this.modID) && !this.getExcludedBlocks().contains(e.getValue())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public abstract List<Block> getExcludedBlocks();
}

