/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.block;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.block.voxelshapes.VoxelShapeProvider;
import voltaic.prefab.block.GenericEntityBlockWaterloggable;

public class GenericMachineBlock
extends GenericEntityBlockWaterloggable {
    private final BlockEntityType.BlockEntitySupplier<BlockEntity> blockEntitySupplier;
    private final VoxelShapeProvider shapeProvider;
    public static HashMap<BlockPos, LivingEntity> IPLAYERSTORABLE_MAP = new HashMap();

    public GenericMachineBlock(BlockEntityType.BlockEntitySupplier<BlockEntity> blockEntitySupplier, VoxelShapeProvider provider) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(3.5f).m_60918_(SoundType.f_56743_).m_60955_().m_60999_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VoltaicBlockStates.FACING, (Comparable)Direction.NORTH));
        this.blockEntitySupplier = blockEntitySupplier;
        this.shapeProvider = provider;
    }

    public GenericMachineBlock(BlockEntityType.BlockEntitySupplier<BlockEntity> blockEntitySupplier, boolean temp) {
        this(blockEntitySupplier, VoxelShapeProvider.DEFAULT);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction dir = null;
        if (state.m_61138_((Property)VoltaicBlockStates.FACING)) {
            dir = (Direction)state.m_61143_((Property)VoltaicBlockStates.FACING);
        }
        return this.shapeProvider.getShape(dir);
    }

    @Override
    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (this.isIPlayerStorable()) {
            IPLAYERSTORABLE_MAP.put(pPos, pPlacer);
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    @Override
    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.blockEntitySupplier.m_155267_(pos, state);
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)VoltaicBlockStates.FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VoltaicBlockStates.FACING});
    }

    public boolean isIPlayerStorable() {
        return false;
    }
}

