/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.inventory.container.slot.item.type;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import voltaic.api.screen.ITexture;
import voltaic.api.screen.component.ISlotTexture;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;

public class SlotRestricted
extends SlotGeneric {
    private List<Item> whitelist;
    private List<Class<?>> classes;
    private List<Capability<?>> validCapabilities;
    private Predicate<ItemStack> mayPlace = stack -> false;

    public SlotRestricted(Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public SlotRestricted(ISlotTexture slot, ITexture icon, Container inv, int index, int x, int y) {
        super(slot, icon, inv, index, x, y);
    }

    public SlotRestricted setRestriction(Predicate<ItemStack> mayPlace) {
        this.mayPlace = mayPlace;
        return this;
    }

    public SlotRestricted setRestriction(Item ... items) {
        this.whitelist = Arrays.asList(items);
        this.mayPlace = stack -> this.whitelist.contains(stack.m_41720_());
        return this;
    }

    public SlotRestricted setRestriction(Class<?> ... items) {
        this.classes = Arrays.asList(items);
        this.mayPlace = stack -> {
            if (this.classes != null) {
                for (Class<?> cl : this.classes) {
                    if (!cl.isInstance(stack.m_41720_())) continue;
                    return true;
                }
            }
            return false;
        };
        return this;
    }

    public SlotRestricted setRestriction(Capability<?> ... capabilities) {
        this.validCapabilities = Arrays.asList(capabilities);
        this.mayPlace = stack -> {
            if (this.validCapabilities != null) {
                for (Capability<?> cap : this.validCapabilities) {
                    if (stack.getCapability(cap) == null) continue;
                    return true;
                }
            }
            return false;
        };
        return this;
    }

    @Override
    public boolean m_5857_(ItemStack stack) {
        return super.m_5857_(stack) && this.mayPlace.test(stack);
    }
}

