/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.variant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.util.TriConsumer;
import voltaic.Voltaic;
import voltaic.prefab.properties.PropertyManager;
import voltaic.prefab.properties.types.IPropertyType;
import voltaic.prefab.properties.types.ListPropertyType;
import voltaic.prefab.properties.variant.AbstractProperty;

public class ListProperty<T>
extends AbstractProperty<List<T>, ListPropertyType<T, ?>> {
    private boolean alreadySynced = false;
    private TriConsumer<ListProperty<T>, List<T>, Integer> onChange = (prop, val, index) -> {};
    private Consumer<ListProperty<T>> onTileLoaded = prop -> {};

    public ListProperty(ListPropertyType<T, ?> type, String name, List<T> defaultValue) {
        super(type, name, defaultValue);
    }

    @Override
    public void onTileLoaded() {
        this.onTileLoaded.accept(this);
    }

    @Override
    public void onLoadedFromTag(AbstractProperty<List<T>, ListPropertyType<T, ?>> prop, List<T> loadedValue) {
        this.onChange.accept((Object)((ListProperty)prop), loadedValue, (Object)-1);
    }

    public ListProperty<T> onChange(TriConsumer<ListProperty<T>, List<T>, Integer> event) {
        this.onChange = event;
        return this;
    }

    public ListProperty<T> onTileLoaded(Consumer<ListProperty<T>> event) {
        this.onTileLoaded = this.onTileLoaded.andThen(event);
        return this;
    }

    @Override
    public void setValue(Object updated) {
        if (this.alreadySynced) {
            return;
        }
        ArrayList old = new ArrayList((Collection)this.getValue());
        this.value = (List)updated;
        this.setDirty();
        PropertyManager manager = this.getPropertyManager();
        if (this.isDirty() && manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)-1);
        }
    }

    public void setValue(Object updated, int index) {
        if (this.alreadySynced) {
            return;
        }
        this.checkForChange(updated, index);
        ArrayList old = new ArrayList((Collection)this.getValue());
        ((List)this.value).set(index, updated);
        PropertyManager manager = this.getPropertyManager();
        if (this.isDirty() && manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)index);
        }
    }

    public void addValue(Object updated) {
        if (this.alreadySynced || updated == null) {
            return;
        }
        ArrayList old = new ArrayList((Collection)this.getValue());
        ((List)this.getValue()).add(updated);
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)-1);
        }
    }

    public void addValue(Object updated, int index) {
        if (this.alreadySynced || updated == null) {
            return;
        }
        ArrayList old = new ArrayList((Collection)this.getValue());
        ((List)this.getValue()).add(index, updated);
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)index);
        }
    }

    public void addValues(List<?> updated) {
        if (this.alreadySynced || updated == null) {
            return;
        }
        ArrayList old = new ArrayList((Collection)this.getValue());
        for (Object obj : updated) {
            ((List)this.getValue()).add(obj);
        }
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)-1);
        }
    }

    public void removeValue(int index) {
        if (this.alreadySynced || index >= ((List)this.getValue()).size()) {
            return;
        }
        ArrayList old = new ArrayList((Collection)this.getValue());
        ((List)this.getValue()).remove(index);
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)index);
        }
    }

    public void removeValue(T value) {
        if (this.alreadySynced || !((List)this.getValue()).contains(value)) {
            return;
        }
        ArrayList old = new ArrayList((Collection)this.getValue());
        ((List)this.getValue()).remove(value);
        PropertyManager manager = this.getPropertyManager();
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)-1);
        }
    }

    public void wipeList() {
        PropertyManager manager = this.getPropertyManager();
        ArrayList old = new ArrayList((Collection)this.getValue());
        this.overwriteValue(new ArrayList());
        this.setDirty();
        if (manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, old, (Object)-1);
        }
    }

    public void copy(ListProperty<T> other) {
        List otherVal = (List)other.getValue();
        if (otherVal == null) {
            return;
        }
        this.overwriteValue(otherVal);
    }

    private boolean checkForChange(T updated, int index) {
        boolean shouldUpdate;
        boolean bl = shouldUpdate = ((List)this.value).get(index) == null && updated != null;
        if (((List)this.value).get(index) != null && updated != null) {
            boolean bl2 = shouldUpdate = !((ListPropertyType)this.getType()).isSingleEqual(((List)this.value).get(index), updated);
        }
        if (shouldUpdate) {
            this.setDirty();
        }
        return shouldUpdate;
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        try {
            Object data = ((ListPropertyType)this.getType()).readFromTag(new IPropertyType.TagReader(this, tag));
            if (data != null) {
                this.value = data;
                this.onLoadedFromTag((AbstractProperty<List<T>, ListPropertyType<T, ?>>)this, (List)this.value);
            }
        }
        catch (Exception e) {
            Voltaic.LOGGER.info("Catching error while loading property " + this.getName() + " from NBT. Error: " + e.getMessage());
        }
    }
}

