/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

public class CachedComponent<S> {
    private final Function<S, Component> builder;
    private S lastState;
    private Component cached;

    public CachedComponent(Function<S, Component> builder) {
        this.builder = Objects.requireNonNull(builder, "builder");
    }

    public Component get(S state) {
        if (this.cached == null || !Objects.equals(this.lastState, state)) {
            this.lastState = state;
            this.cached = this.builder.apply(state);
        }
        return this.cached;
    }

    public void invalidate() {
        this.lastState = null;
        this.cached = null;
    }
}

