/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.button.type;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.utilities.RenderingUtils;

public class ButtonTankSlider
extends ScreenComponentButton<ButtonTankSlider> {
    private final TankSliderPair pair;

    public ButtonTankSlider(TankSliderPair pair, int x, int y) {
        super(pair.off, x, y);
        this.pair = pair;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.isVisible() && this.isHovered()) {
            RenderingUtils.setShaderColor(this.color);
            TankSliderTextures on = this.pair.on;
            graphics.m_280163_(on.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation, (float)on.textureU(), (float)on.textureV(), on.textureWidth(), on.textureHeight(), on.imageWidth(), on.imageHeight());
            RenderingUtils.resetShaderColor();
        } else {
            super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        }
    }

    public static enum TankSliderPair {
        LEFT(TankSliderTextures.LEFT_DEFAULT, TankSliderTextures.LEFT_HOVERED),
        RIGHT(TankSliderTextures.RIGHT_DEFAULT, TankSliderTextures.RIGHT_HOVERED);

        private final TankSliderTextures off;
        private final TankSliderTextures on;

        private TankSliderPair(TankSliderTextures off, TankSliderTextures on) {
            this.off = off;
            this.on = on;
        }
    }

    public static enum TankSliderTextures implements ITexture
    {
        LEFT_DEFAULT(6, 9, 0, 0, 12, 18),
        LEFT_HOVERED(6, 9, 0, 9, 12, 18),
        RIGHT_DEFAULT(6, 9, 6, 0, 12, 18),
        RIGHT_HOVERED(6, 9, 6, 9, 12, 18);

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private TankSliderTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/component/button/tankarrows.png");
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

