/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.utils;

import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import voltaic.api.screen.IScreenWrapper;

public abstract class AbstractScreenComponent
implements GuiEventListener,
Renderable,
NarratableEntry {
    public int xLocation;
    public int yLocation;
    public int width;
    public int height;
    private boolean isVisible = true;
    private boolean isActive = true;
    private boolean isHovered = false;
    private boolean isFocused = false;
    public IScreenWrapper gui;

    public AbstractScreenComponent(int x, int y, int width, int height) {
        this.xLocation = x;
        this.yLocation = y;
        this.width = width;
        this.height = height;
    }

    public AbstractScreenComponent setScreen(IScreenWrapper gui) {
        this.gui = gui;
        return this;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible()) {
            this.setHovered(this.m_5953_(mouseX, mouseY));
            int guiWidth = (int)this.gui.getGuiWidth();
            int guiHeight = (int)this.gui.getGuiHeight();
            this.renderBackground(graphics, mouseX - guiWidth, mouseY - guiHeight, guiWidth, guiHeight);
        }
    }

    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
    }

    public void renderForeground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
    }

    public void renderBoundedText(GuiGraphics graphics, Component text, int x, int y, int color, int maxLength) {
        int length = this.gui.getFontRenderer().m_92852_((FormattedText)text);
        if (length <= maxLength) {
            graphics.m_280430_(this.gui.getFontRenderer(), text, x, y, color);
        } else {
            float scale = (float)maxLength / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            graphics.m_280430_(this.gui.getFontRenderer(), text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            graphics.m_280168_().m_85849_();
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.isPointInRegion(this.xLocation, this.yLocation, mouseX - this.gui.getGuiWidth(), mouseY - this.gui.getGuiHeight(), this.width, this.height);
    }

    public Rect2i getClickArea() {
        return new Rect2i(this.xLocation + (int)this.gui.getGuiWidth(), this.yLocation + (int)this.gui.getGuiHeight(), this.width, this.height);
    }

    public boolean isInClickRegion(double mouseX, double mouseY) {
        return this.m_5953_(mouseX, mouseY);
    }

    protected boolean isPointInRegion(int x, int y, double xAxis, double yAxis, int width, int height) {
        return xAxis >= (double)x && xAxis <= (double)(x + width - 1) && yAxis >= (double)y && yAxis <= (double)(y + height - 1);
    }

    public void preOnMouseClick(double mouseX, double mouseY, int button) {
    }

    public void onMouseClick(double mouseX, double mouseY) {
    }

    public void onMouseRelease(double mouseX, double mouseY) {
    }

    public void onMouseDrag(double mouseX, double mouseY, double dragX, double dragY) {
    }

    public void onMouseScroll(double mouseX, double mouseY, double delta) {
    }

    public boolean isValidClick(int button) {
        return button == 0;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean m_142518_() {
        return this.isActive;
    }

    public void setHovered(boolean isHovered) {
        this.isHovered = isHovered;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public void m_93692_(boolean isFocused) {
        this.isFocused = isFocused;
        this.onFocusChanged(isFocused);
    }

    public boolean m_93696_() {
        return this.isFocused;
    }

    public void onFocusChanged(boolean isFocused) {
    }

    public boolean isHoveredOrFocused() {
        return this.isHovered() || this.m_93696_();
    }

    public boolean isActiveAndVisible() {
        return this.m_142518_() && this.isVisible();
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        if (this.m_93696_()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.isHovered() ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent pEvent) {
        if (this.m_142518_() && this.isVisible()) {
            return !this.m_93696_() ? ComponentPath.m_264401_((GuiEventListener)this) : null;
        }
        return null;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static interface OnTooltip {
        public void onTooltip(GuiGraphics var1, AbstractScreenComponent var2, int var3, int var4);
    }
}

