/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.items.IItemHandlerModifiable;
import voltaic.api.inventory.IndexedSidedInvWrapper;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.utilities.BlockEntityUtils;

public class ComponentInventory
implements IComponent,
WorldlyContainer {
    protected static final int[] SLOTS_EMPTY = new int[0];
    public static final String SAVE_KEY = "itemproperty";
    protected GenericTile holder = null;
    private final ListProperty<ItemStack> items;
    protected TriPredicate<Integer, ItemStack, ComponentInventory> itemValidTest = (x, y, i) -> true;
    protected HashSet<Player> viewing = new HashSet();
    public HashSet<Integer>[] relativeDirectionToSlotsMap = new HashSet[6];
    protected int inventorySize;
    protected Function<Direction, Collection<Integer>> getSlotsFunction;
    private final IItemHandlerModifiable[] sidedOptionals = IndexedSidedInvWrapper.create(this, Direction.values());
    private int[][] slotsForFace = ComponentInventory.createArr();
    private int inputs = 0;
    private int outputs = 0;
    private int upgrades = 0;
    private int biproducts = 0;
    private int bucketInputs = 0;
    private int bucketOutputs = 0;
    private int gasInputs = 0;
    private int gasOutputs = 0;
    private int inputsPerProc = 0;
    private int outputsPerProc = 0;
    private int biprodsPerProc = 0;
    private BiConsumer<ComponentInventory, Integer> onChanged = (componentInventory, slot) -> {
        if (this.holder != null) {
            this.holder.onInventoryChange((ComponentInventory)componentInventory, (int)slot);
        }
    };
    protected SubtypeItemUpgrade[] validUpgrades = SubtypeItemUpgrade.values();

    private static int[][] createArr() {
        int[][] arr = new int[6][];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new int[0];
        }
        return arr;
    }

    public ComponentInventory(GenericTile holder) {
        this(holder, InventoryBuilder.EMPTY);
    }

    public ComponentInventory(GenericTile holder, InventoryBuilder builder) {
        this.holder(holder);
        if (!holder.m_58900_().m_61138_((Property)VoltaicBlockStates.FACING)) {
            throw new UnsupportedOperationException("The tile " + holder + " must have the FACING direction property!");
        }
        if (builder.builderSize > 0) {
            this.inventorySize = builder.builderSize;
        } else {
            this.inputs = builder.builderInputs;
            this.outputs = builder.builderOutputs;
            this.upgrades = builder.builderUpgrades;
            this.biproducts = builder.builderBiproducts;
            this.bucketInputs = builder.builderBucketInputs;
            this.bucketOutputs = builder.builderBucketOutputs;
            this.gasInputs = builder.builderGasInputs;
            this.gasOutputs = builder.builderGasOutputs;
            this.inventorySize = this.inputs + this.outputs + this.upgrades + this.biproducts + this.bucketInputs + this.bucketOutputs + this.gasInputs + this.gasOutputs + this.upgrades;
            this.inputsPerProc = builder.builderInputsPerProc;
            this.outputsPerProc = builder.builderOutputsPerProc;
            this.biprodsPerProc = builder.builderBiprodsPerProc;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.inventorySize);
        for (int i2 = 0; i2 < this.inventorySize; ++i2) {
            items.add(ItemStack.f_41583_);
        }
        this.items = holder.property(new ListProperty<ItemStack>(PropertyTypes.ITEM_STACK_LIST, "machineinventory", items));
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    public ComponentInventory onChanged(BiConsumer<ComponentInventory, Integer> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public ComponentInventory getSlots(Function<Direction, Collection<Integer>> getSlotsFunction) {
        this.getSlotsFunction = getSlotsFunction;
        return this;
    }

    public ComponentInventory setSlotsByDirection(BlockEntityUtils.MachineDirection face, Integer ... slot) {
        Direction faceDir = face.mappedDir;
        if (this.relativeDirectionToSlotsMap[faceDir.ordinal()] == null) {
            this.relativeDirectionToSlotsMap[faceDir.ordinal()] = new HashSet();
        }
        for (Integer sl : slot) {
            this.relativeDirectionToSlotsMap[faceDir.ordinal()].add(sl);
        }
        return this;
    }

    public ComponentInventory setDirectionsBySlot(Integer slot, BlockEntityUtils.MachineDirection ... faces) {
        for (BlockEntityUtils.MachineDirection face : faces) {
            this.setSlotsByDirection(face, slot);
        }
        return this;
    }

    public ComponentInventory setSlotsForAllDirections(Integer ... slots) {
        for (BlockEntityUtils.MachineDirection faceDirection : BlockEntityUtils.MachineDirection.values()) {
            this.setSlotsByDirection(faceDirection, slots);
        }
        return this;
    }

    public ComponentInventory implementMachineInputsAndOutputs() {
        ComponentInventory inv = this;
        for (int i : this.getInputSlots()) {
            inv = inv.setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, i).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, i);
        }
        for (int i : this.getOutputSlots()) {
            inv = inv.setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, i).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, i);
        }
        for (int i : this.getBiproductSlots()) {
            inv = inv.setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, i).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, i);
        }
        return inv;
    }

    public ComponentInventory valid(TriPredicate<Integer, ItemStack, ComponentInventory> itemValidPredicate) {
        this.itemValidTest = itemValidPredicate;
        return this;
    }

    public void m_5856_(Player player) {
        this.viewing.add(player);
    }

    public void m_5785_(Player player) {
        this.viewing.remove(player);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
        if (side == null) {
            return LazyOptional.empty();
        }
        return LazyOptional.of(() -> this.sidedOptionals[side.ordinal()]).cast();
    }

    @Override
    public void refresh() {
        this.defineOptionals(this.holder.getFacing());
    }

    @Override
    public void refreshIfUpdate(BlockState oldState, BlockState newState) {
        if (oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.defineOptionals((Direction)newState.m_61143_((Property)VoltaicBlockStates.FACING));
        }
    }

    private void defineOptionals(Direction facing) {
        this.holder.invalidateCaps();
        this.slotsForFace = new int[6][];
        for (Direction dir : Direction.values()) {
            Direction relative = BlockEntityUtils.getRelativeSide(facing, dir);
            HashSet<Integer> slots = this.relativeDirectionToSlotsMap[dir.ordinal()];
            if (slots == null) {
                this.slotsForFace[relative.ordinal()] = SLOTS_EMPTY;
                continue;
            }
            int[] arr = new int[slots.size()];
            int i = 0;
            for (Integer integer : slots) {
                arr[i] = integer;
                ++i;
            }
            this.slotsForFace[relative.ordinal()] = arr;
        }
    }

    public int m_6643_() {
        return this.inventorySize;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : (List)this.items.getValue()) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)((List)this.items.getValue()).get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (index < 0 || index >= ((List)this.items.getValue()).size() || count <= 0 || ((ItemStack)((List)this.items.getValue()).get(index)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack indexItem = (ItemStack)((List)this.items.getValue()).get(index);
        ItemStack taken = indexItem.m_41620_(count);
        this.items.setValue(indexItem, index);
        this.setChanged(index);
        return taken;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_((List)((List)this.items.getValue()), (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index < 0 || index >= ((List)this.items.getValue()).size() || ItemStack.m_41728_((ItemStack)((ItemStack)((List)this.items.getValue()).get(index)), (ItemStack)stack)) {
            return;
        }
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.items.setValue(stack, index);
        this.setChanged(index);
    }

    public boolean m_6542_(Player player) {
        BlockPos pos = this.holder.m_58899_();
        return this.holder.m_58904_().m_7702_(pos) == this.holder && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.wipeList();
    }

    public int[] m_7071_(Direction side) {
        if (this.getSlotsFunction != null) {
            return this.getSlotsFunction.apply(side).stream().mapToInt(i -> i).toArray();
        }
        return side == null ? SLOTS_EMPTY : this.slotsForFace[side.ordinal()];
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.itemValidTest.test((Object)index, (Object)stack, (Object)this);
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        ArrayList<Integer> test = new ArrayList<Integer>();
        for (int i : this.m_7071_(direction)) {
            test.add(i);
        }
        return test.contains(index) && this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        ArrayList<Integer> test = new ArrayList<Integer>();
        for (int i : this.m_7071_(direction)) {
            test.add(i);
        }
        return test.contains(index);
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList its = NonNullList.m_122779_();
        its.addAll((Collection)this.items.getValue());
        return its;
    }

    public HashSet<Player> getViewing() {
        return this.viewing;
    }

    @Override
    public IComponentType getType() {
        return IComponentType.Inventory;
    }

    @Override
    public void remove() {
    }

    public void m_6596_() {
        this.setChanged(-1);
    }

    public void setChanged(int slot) {
        if (this.onChanged != null) {
            this.onChanged.accept(this, slot);
        }
    }

    public int inputs() {
        return this.inputs;
    }

    public int outputs() {
        return this.outputs;
    }

    public int upgrades() {
        return this.upgrades;
    }

    public ComponentInventory validUpgrades(SubtypeItemUpgrade ... upgrades) {
        this.validUpgrades = upgrades;
        return this;
    }

    public SubtypeItemUpgrade[] validUpgrades() {
        return this.validUpgrades;
    }

    public int biproducts() {
        return this.biproducts;
    }

    public int bucketInputs() {
        return this.bucketInputs;
    }

    public int bucketOutputs() {
        return this.bucketOutputs;
    }

    public int gasInputs() {
        return this.gasInputs;
    }

    public int gasOutputs() {
        return this.gasOutputs;
    }

    public int getInputStartIndex() {
        return 0;
    }

    public int getOutputStartIndex() {
        return this.inputs;
    }

    public int getItemBiproductStartIndex() {
        return this.getOutputStartIndex() + this.outputs;
    }

    public int getInputBucketStartIndex() {
        return this.getItemBiproductStartIndex() + this.biproducts;
    }

    public int getOutputBucketStartIndex() {
        return this.getInputBucketStartIndex() + this.bucketInputs;
    }

    public int getInputGasStartIndex() {
        return this.getOutputBucketStartIndex() + this.bucketOutputs;
    }

    public int getOutputGasStartIndex() {
        return this.getInputGasStartIndex() + this.gasInputs;
    }

    public int getUpgradeSlotStartIndex() {
        return this.getOutputGasStartIndex() + this.gasOutputs;
    }

    public List<ItemStack> getInputContents() {
        return ((List)this.items.getValue()).subList(this.getInputStartIndex(), this.getOutputStartIndex());
    }

    public List<ItemStack> getOutputContents() {
        return ((List)this.items.getValue()).subList(this.getOutputStartIndex(), this.getItemBiproductStartIndex());
    }

    public List<ItemStack> getItemBiContents() {
        return ((List)this.items.getValue()).subList(this.getItemBiproductStartIndex(), this.getInputBucketStartIndex());
    }

    public List<ItemStack> getInputBucketContents() {
        return ((List)this.items.getValue()).subList(this.getInputBucketStartIndex(), this.getOutputBucketStartIndex());
    }

    public List<ItemStack> getOutputBucketContents() {
        return ((List)this.items.getValue()).subList(this.getOutputBucketStartIndex(), this.getUpgradeSlotStartIndex());
    }

    public List<ItemStack> getInputGasContents() {
        return ((List)this.items.getValue()).subList(this.getInputGasStartIndex(), this.getOutputGasStartIndex());
    }

    public List<ItemStack> getOutputGasContents() {
        return ((List)this.items.getValue()).subList(this.getOutputGasStartIndex(), this.getUpgradeSlotStartIndex());
    }

    public List<ItemStack> getUpgradeContents() {
        return ((List)this.items.getValue()).subList(this.getUpgradeSlotStartIndex(), ((List)this.items.getValue()).size());
    }

    public List<ItemStack> getInputsForProcessor(int processor) {
        return this.getInputContents().subList(this.inputsPerProc * processor, this.inputsPerProc * (processor + 1));
    }

    public List<ItemStack> getOutputsForProcessor(int processor) {
        return this.getOutputContents().subList(this.outputsPerProc * processor, this.outputsPerProc * (processor + 1));
    }

    public List<ItemStack> getBiprodsForProcessor(int processor) {
        return this.getItemBiContents().subList(this.biprodsPerProc * processor, this.biprodsPerProc * (processor + 1));
    }

    public List<Integer> getInputSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.inputs; ++i) {
            list.add(this.getInputStartIndex() + i);
        }
        return list;
    }

    public List<Integer> getOutputSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.outputs; ++i) {
            list.add(this.getOutputStartIndex() + i);
        }
        return list;
    }

    public List<Integer> getBiproductSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.biproducts; ++i) {
            list.add(this.getItemBiproductStartIndex() + i);
        }
        return list;
    }

    public List<Integer> getInputSlotsForProcessor(int processor) {
        return this.getInputSlots().subList(this.inputsPerProc * processor, this.inputsPerProc * (processor + 1));
    }

    public List<Integer> getOutputSlotsForProcessor(int processor) {
        return this.getOutputSlots().subList(this.outputsPerProc * processor, this.outputsPerProc * (processor + 1));
    }

    public List<Integer> getBiprodSlotsForProcessor(int processor) {
        return this.getBiproductSlots().subList(this.biprodsPerProc * processor, this.biprodsPerProc * (processor + 1));
    }

    public boolean areOutputsEmpty() {
        boolean output = false;
        boolean biproduct = false;
        for (ItemStack stack : this.getOutputContents()) {
            if (!stack.m_41619_()) continue;
            output = true;
            break;
        }
        if (!this.getItemBiContents().isEmpty()) {
            for (ItemStack stack : this.getItemBiContents()) {
                if (!stack.m_41619_()) continue;
                biproduct = true;
                break;
            }
        } else {
            biproduct = true;
        }
        return output && biproduct;
    }

    public boolean hasItemsInOutput() {
        for (ItemStack stack : this.getOutputContents()) {
            if (stack.m_41619_()) continue;
            return true;
        }
        for (ItemStack stack : this.getItemBiContents()) {
            if (stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean areInputsEmpty() {
        for (ItemStack stack : this.getInputContents()) {
            if (!stack.m_41619_()) continue;
            return false;
        }
        return false;
    }

    public boolean hasInputRoom() {
        for (ItemStack stack : this.getInputContents()) {
            if (stack.m_41741_() <= stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public boolean isUpgradeValid(SubtypeItemUpgrade upgrade) {
        for (SubtypeItemUpgrade subtype : this.validUpgrades) {
            if (subtype != upgrade) continue;
            return true;
        }
        return false;
    }

    public static class InventoryBuilder {
        private static final InventoryBuilder EMPTY = new InventoryBuilder();
        private int builderSize = 0;
        private int builderInputs = 0;
        private int builderOutputs = 0;
        private int builderBiproducts = 0;
        private int builderBucketInputs = 0;
        private int builderBucketOutputs = 0;
        private int builderUpgrades = 0;
        private int builderGasInputs = 0;
        private int builderGasOutputs = 0;
        private int builderInputsPerProc = 0;
        private int builderOutputsPerProc = 0;
        private int builderBiprodsPerProc = 0;

        private InventoryBuilder() {
        }

        public InventoryBuilder inputs(int inputs) {
            this.builderInputs = inputs;
            return this;
        }

        public InventoryBuilder outputs(int outputs) {
            this.builderOutputs = outputs;
            return this;
        }

        public InventoryBuilder biproducts(int biproducts) {
            this.builderBiproducts = biproducts;
            return this;
        }

        public InventoryBuilder bucketInputs(int bucketInputs) {
            this.builderBucketInputs = bucketInputs;
            return this;
        }

        public InventoryBuilder bucketOutputs(int bucketOutputs) {
            this.builderBucketOutputs = bucketOutputs;
            return this;
        }

        public InventoryBuilder gasInputs(int gasInputs) {
            this.builderGasInputs = gasInputs;
            return this;
        }

        public InventoryBuilder gasOutputs(int gasOutputs) {
            this.builderGasOutputs = gasOutputs;
            return this;
        }

        public InventoryBuilder upgrades(int upgrades) {
            this.builderUpgrades = upgrades;
            return this;
        }

        public InventoryBuilder processors(int procCount, int inputsPerProc, int outputsPerProc, int biprodsPerProc) {
            this.builderInputsPerProc = inputsPerProc;
            this.builderOutputsPerProc = outputsPerProc;
            this.builderBiprodsPerProc = biprodsPerProc;
            this.builderInputs = procCount * inputsPerProc;
            this.builderOutputs = procCount * outputsPerProc;
            this.builderBiproducts = procCount * biprodsPerProc;
            return this;
        }

        public InventoryBuilder forceSize(int size) {
            this.builderSize = size;
            return this;
        }

        public static InventoryBuilder newInv() {
            return new InventoryBuilder();
        }
    }
}

