/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;

public class ComponentTickable
implements IComponent {
    private GenericTile holder;
    protected Consumer<ComponentTickable> tickCommon;
    protected Consumer<ComponentTickable> tickClient;
    protected Consumer<ComponentTickable> tickServer;
    private long ticks = 0L;

    public ComponentTickable(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    public ComponentTickable tickCommon(@Nonnull Consumer<ComponentTickable> consumer) {
        Consumer<ComponentTickable> safe = consumer;
        if (this.tickCommon != null) {
            safe = safe.andThen(this.tickCommon);
        }
        this.tickCommon = safe;
        return this;
    }

    public ComponentTickable tickClient(@Nonnull Consumer<ComponentTickable> consumer) {
        Consumer<ComponentTickable> safe = consumer;
        if (this.tickClient != null) {
            safe = safe.andThen(this.tickClient);
        }
        this.tickClient = safe;
        return this;
    }

    public ComponentTickable tickServer(@Nonnull Consumer<ComponentTickable> consumer) {
        Consumer<ComponentTickable> safe = consumer;
        if (this.tickServer != null) {
            safe = safe.andThen(this.tickServer);
        }
        this.tickServer = safe;
        return this;
    }

    public void tickCommon() {
        ++this.ticks;
        if (this.tickCommon != null) {
            this.tickCommon.accept(this);
        }
    }

    public void tickServer() {
        if (this.tickServer != null) {
            this.tickServer.accept(this);
        }
    }

    public void tickClient() {
        if (this.tickClient != null) {
            this.tickClient.accept(this);
        }
    }

    public long getTicks() {
        return this.ticks;
    }

    public void performTick(Level level) {
        if (level == null) {
            return;
        }
        this.tickCommon();
        if (level.f_46443_) {
            this.tickClient();
        } else {
            this.tickServer();
            if (this.holder != null && (this.holder.getPropertyManager().isDirty() || this.holder.isChanged)) {
                this.holder.m_6596_();
                this.holder.m_58904_().m_7260_(this.holder.m_58899_(), this.holder.m_58900_(), this.holder.m_58900_(), 2);
                this.holder.isChanged = false;
            }
        }
    }

    @Override
    public IComponentType getType() {
        return IComponentType.Tickable;
    }
}

