/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities.object;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import voltaic.api.codec.StreamCodec;

public final class Location {
    public static final Codec<Location> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(Location::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(Location::y), (App)Codec.DOUBLE.fieldOf("z").forGetter(Location::z)).apply((Applicative)instance, Location::new));
    public static final StreamCodec<ByteBuf, Location> STREAM_CODEC = new StreamCodec<ByteBuf, Location>(){

        @Override
        public void encode(ByteBuf buffer, Location value) {
            buffer.writeDouble(value.x);
            buffer.writeDouble(value.y);
            buffer.writeDouble(value.z);
        }

        @Override
        public Location decode(ByteBuf buffer) {
            return new Location(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    protected double x;
    protected double y;
    protected double z;

    public Location() {
    }

    public Location(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public Location(BlockPos pos) {
        this.x = (double)pos.m_123341_() + 0.5;
        this.y = (double)pos.m_123342_() + 0.5;
        this.z = (double)pos.m_123343_() + 0.5;
    }

    public Location(Vector3f vec) {
        this.x = vec.x();
        this.y = vec.y();
        this.z = vec.z();
    }

    public Location(Vec3 vec) {
        this.x = vec.f_82479_;
        this.y = vec.f_82480_;
        this.z = vec.f_82481_;
    }

    public Location(Location loc) {
        this.x = loc.x;
        this.y = loc.y;
        this.z = loc.z;
    }

    public Location(Entity entity) {
        this.x = entity.m_20185_();
        this.y = entity.m_20186_();
        this.z = entity.m_20189_();
    }

    public Location mul(double val) {
        this.x *= val;
        this.y *= val;
        this.z *= val;
        return this;
    }

    public Location mul(double xval, double yval, double zval) {
        this.x *= xval;
        this.y *= yval;
        this.z *= zval;
        return this;
    }

    public Location mul(Location loc) {
        this.x *= loc.x;
        this.y *= loc.y;
        this.z *= loc.z;
        return this;
    }

    public Location set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Location set(Location loc) {
        this.x = loc.x;
        this.y = loc.y;
        this.z = loc.z;
        return this;
    }

    public Location add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Location add(Location loc) {
        this.x += loc.x;
        this.y += loc.y;
        this.z += loc.z;
        return this;
    }

    public Location normalize() {
        double dis = this.distance(new Location());
        this.x /= dis;
        this.y /= dis;
        this.z /= dis;
        return this;
    }

    public double distanceSq(Location loc) {
        return Math.pow(this.x - loc.x, 2.0) + Math.pow(this.y - loc.y, 2.0) + Math.pow(this.z - loc.z, 2.0);
    }

    public double distance(Location loc) {
        return Math.sqrt(this.distanceSq(loc));
    }

    public double distancelinear(Location loc) {
        return Math.abs(this.x - loc.x) + Math.abs(this.y - loc.y) + Math.abs(this.z - loc.z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
    }

    public BlockState getBlockState(BlockGetter reader) {
        return reader.m_8055_(this.toBlockPos());
    }

    public Block getBlock(BlockGetter reader) {
        return this.getBlockState(reader).m_60734_();
    }

    public BlockEntity getTile(BlockGetter reader) {
        return reader.m_7702_(this.toBlockPos());
    }

    public Location setBlockState(Level world, BlockState state) {
        world.m_46597_(this.toBlockPos(), state);
        return this;
    }

    public Location setBlock(Level world, Block block) {
        return this.setBlockState(world, block.m_49966_());
    }

    public Location setAir(Level world) {
        return this.setBlock(world, Blocks.f_50016_);
    }

    public Location setAirFast(Level world) {
        world.m_7731_(this.toBlockPos(), Blocks.f_50016_.m_49966_(), 18);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return Double.doubleToLongBits(this.x) == Double.doubleToLongBits(other.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y) && Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "[" + this.intX() + ", " + this.intY() + ", " + this.intZ() + "]";
    }

    public static Location readFromNBT(CompoundTag nbt, String name) {
        return new Location(nbt.m_128459_(name + "X"), nbt.m_128459_(name + "Y"), nbt.m_128459_(name + "Z"));
    }

    public void writeToNBT(CompoundTag nbt, String name) {
        nbt.m_128347_(name + "X", this.x);
        nbt.m_128347_(name + "Y", this.y);
        nbt.m_128347_(name + "Z", this.z);
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        STREAM_CODEC.encode((ByteBuf)buffer, this);
    }

    public static Location fromBuffer(FriendlyByteBuf buffer) {
        return STREAM_CODEC.decode((ByteBuf)buffer);
    }
}

