/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities.object;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import voltaic.api.codec.StreamCodec;

public class TransferPack {
    public static final Codec<TransferPack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("joules").forGetter(TransferPack::getJoules), (App)Codec.DOUBLE.fieldOf("voltage").forGetter(TransferPack::getVoltage)).apply((Applicative)instance, (joules, voltage) -> TransferPack.joulesVoltage(joules, voltage)));
    public static final StreamCodec<ByteBuf, TransferPack> STREAM_CODEC = new StreamCodec<ByteBuf, TransferPack>(){

        @Override
        public void encode(ByteBuf buffer, TransferPack value) {
            buffer.writeDouble(value.joules);
            buffer.writeDouble(value.voltage);
        }

        @Override
        public TransferPack decode(ByteBuf buffer) {
            return new TransferPack(buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final TransferPack EMPTY = new TransferPack(0.0, 0.0);
    private double joules;
    private double voltage;

    private TransferPack(double joules, double voltage) {
        this.joules = joules;
        this.voltage = voltage;
    }

    public static TransferPack ampsVoltage(double amps, double voltage) {
        return new TransferPack(amps / 20.0 * voltage, voltage);
    }

    public static TransferPack joulesVoltage(double joules, double voltage) {
        return new TransferPack(joules, voltage);
    }

    public double getAmps() {
        return this.joules / this.voltage * 20.0;
    }

    public double getAmpsInTicks() {
        return this.joules / this.voltage;
    }

    public double getVoltage() {
        return this.voltage;
    }

    public double getJoules() {
        return this.joules;
    }

    public double getWatts() {
        return this.joules * 20.0;
    }

    public boolean valid() {
        return (int)this.voltage != 0;
    }

    public CompoundTag writeToTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("joules", this.joules);
        tag.m_128347_("voltage", this.voltage);
        return tag;
    }

    public static TransferPack readFromTag(CompoundTag tag) {
        return TransferPack.joulesVoltage(tag.m_128459_("joules"), tag.m_128459_("voltage"));
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeDouble(this.joules);
        buf.writeDouble(this.voltage);
    }

    public static TransferPack readFromBuffer(FriendlyByteBuf buf) {
        return TransferPack.joulesVoltage(buf.readDouble(), buf.readDouble());
    }

    public String toString() {
        return "Joules: " + this.joules + " J, Voltage: " + this.voltage + " V";
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransferPack) {
            TransferPack other = (TransferPack)obj;
            return other.joules == this.joules && other.voltage == this.voltage;
        }
        return false;
    }
}

