/*
 * Decompiled with CFR 0.152.
 */
package voltaic.registers;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import voltaic.api.creativetab.CreativeTabSupplier;
import voltaic.api.registration.BulkRegistryObject;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.gear.ItemGuidebook;
import voltaic.common.item.gear.ItemWrench;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.registers.VoltaicCreativeTabs;

public class VoltaicItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"voltaic");
    public static final RegistryObject<ItemWrench> ITEM_WRENCH = ITEMS.register("wrench", () -> new ItemWrench(new Item.Properties().m_41487_(1), (Supplier<CreativeModeTab>)VoltaicCreativeTabs.MAIN));
    public static final RegistryObject<ItemGuidebook> GUIDEBOOK = ITEMS.register("guidebook", () -> new ItemGuidebook(new Item.Properties(), (Supplier<CreativeModeTab>)VoltaicCreativeTabs.MAIN));
    public static final BulkRegistryObject<ItemUpgrade, SubtypeItemUpgrade> ITEMS_UPGRADE = new BulkRegistryObject(SubtypeItemUpgrade.values(), subtype -> ITEMS.register(subtype.tag(), () -> new ItemUpgrade(new Item.Properties(), (SubtypeItemUpgrade)subtype, (Supplier)VoltaicCreativeTabs.MAIN){

        @Override
        public boolean hasCreativeTab() {
            if (super.hasCreativeTab()) {
                for (String modId : this.subtype.modIds) {
                    if (!ModList.get().isLoaded(modId)) continue;
                    return true;
                }
            }
            return false;
        }
    }));

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="voltaic", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class VoltaicCreativeRegistry {
        @SubscribeEvent
        public static void registerItems(BuildCreativeModeTabContentsEvent event) {
            ITEMS.getEntries().forEach(reg -> {
                CreativeTabSupplier supplier = (CreativeTabSupplier)reg.get();
                if (supplier.hasCreativeTab() && supplier.isAllowedInCreativeTab(event.getTab())) {
                    ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
                    supplier.addCreativeModeItems(event.getTab(), toAdd);
                    event.m_246601_(toAdd);
                }
            });
        }
    }
}

