/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks;

import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.base.Wrenchable;
import earth.terrarium.adastra.common.blocks.properties.SlidingDoorPartProperty;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlidingDoorBlock
extends BasicEntityBlock
implements Wrenchable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty LOCKED = BlockStateProperties.f_61444_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<SlidingDoorPartProperty> PART = EnumProperty.m_61587_((String)"part", SlidingDoorPartProperty.class);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);

    public SlidingDoorBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.BLOCK), true);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)SlidingDoorPartProperty.BOTTOM)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, LOCKED, POWERED, PART});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
        };
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.SLIDING_DOOR_INFO);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockState controllerState = level.m_8055_(this.getController(state, pos));
        if (!controllerState.m_61148_().containsKey(PART)) {
            return super.m_5939_(state, level, pos, context);
        }
        return (Boolean)controllerState.m_61143_((Property)OPEN) != false || (Boolean)controllerState.m_61143_((Property)POWERED) != false ? Shapes.m_83040_() : super.m_5939_(state, level, pos, context);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> {
                if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() || ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((SlidingDoorPartProperty)((Object)state.m_61143_(PART))).isController() ? super.m_142194_(pos, state) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos controllerPos = this.getController(state, pos);
        BlockState controllerState = level.m_8055_(controllerPos);
        if (controllerState.m_60795_()) {
            return InteractionResult.PASS;
        }
        boolean locked = (Boolean)controllerState.m_61143_((Property)LOCKED);
        if (level.m_5776_()) {
            return locked ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (locked) {
            return InteractionResult.PASS;
        }
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            BlockPos partPos = controllerPos.m_5484_(direction, part.xOffset()).m_6630_(part.yOffset());
            BlockState partState = level.m_8055_(partPos);
            level.m_46597_(partPos, (BlockState)partState.m_61122_((Property)OPEN));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            BlockPos partPos = pos.m_5484_(direction.m_122424_(), part.xOffset()).m_6630_(part.yOffset());
            level.m_7731_(partPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)part)), 2);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockPos controllerPos;
        BlockState controllerState;
        if (!level.m_5776_() && (controllerState = level.m_8055_(controllerPos = this.getController(state, pos))).m_60734_() instanceof SlidingDoorBlock) {
            level.m_7731_(controllerPos, (BlockState)controllerState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(pos))), 2);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (!Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_())) {
            return false;
        }
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            BlockPos offset = pos.m_5484_(direction, part.xOffset()).m_6630_(part.yOffset());
            if (level.m_8055_(offset).m_60795_()) continue;
            return false;
        }
        return true;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.destroy(level, pos, state);
        super.m_5707_(level, pos, state, player);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.m_5776_()) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.m_121945_(direction);
                BlockState state = level.m_8055_(offset);
                if (!state.m_60734_().equals(this)) continue;
                this.destroy(level, offset, state);
                break;
            }
        }
        super.m_7592_(level, pos, explosion);
    }

    private void destroy(Level level, BlockPos pos, BlockState state) {
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        BlockPos controllerPos = this.getController(state, pos);
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            BlockPos partPos = controllerPos.m_5484_(direction, part.xOffset()).m_6630_(part.yOffset());
            level.m_46961_(partPos, true);
        }
    }

    private BlockPos getController(BlockState state, BlockPos pos) {
        SlidingDoorPartProperty part = (SlidingDoorPartProperty)((Object)state.m_61143_(PART));
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        return pos.m_5484_(direction.m_122424_(), -part.xOffset()).m_6625_(part.yOffset());
    }

    @Override
    public void onWrench(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        BlockPos controllerPos = this.getController(state, pos);
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        for (SlidingDoorPartProperty part : SlidingDoorPartProperty.values()) {
            BlockPos partPos = controllerPos.m_5484_(direction, part.xOffset()).m_6630_(part.yOffset());
            BlockState partState = level.m_8055_(partPos);
            level.m_46597_(partPos, (BlockState)partState.m_61122_((Property)LOCKED));
            if (((Boolean)partState.m_61143_((Property)LOCKED)).booleanValue()) {
                user.m_5661_(ConstantComponents.DOOR_UNLOCKED, true);
                continue;
            }
            user.m_5661_(ConstantComponents.DOOR_LOCKED, true);
        }
        level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.WRENCH.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.9f);
    }
}

