/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.menus;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.client.screens.PlanetsScreen;
import earth.terrarium.adastra.common.compat.argonauts.ArgonautsIntegration;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import earth.terrarium.adastra.common.menus.base.PlanetsMenuProvider;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundConstructSpaceStationPacket;
import earth.terrarium.adastra.common.planets.AdAstraData;
import earth.terrarium.adastra.common.recipes.SpaceStationRecipe;
import earth.terrarium.adastra.common.recipes.base.IngredientHolder;
import earth.terrarium.adastra.common.registry.ModMenus;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class PlanetsMenu
extends AbstractContainerMenu {
    protected final int tier;
    protected final Inventory inventory;
    protected final Player player;
    protected final Level level;
    protected final Set<ResourceLocation> disabledPlanets;
    protected final Map<ResourceKey<Level>, Map<UUID, Set<SpaceStation>>> spaceStations;
    protected final Map<ResourceKey<Level>, List<Pair<ItemStack, Integer>>> ingredients;
    protected final Object2BooleanMap<ResourceKey<Level>> claimedChunks = new Object2BooleanOpenHashMap();
    protected final Set<GlobalPos> spawnLocations;

    public PlanetsMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        this(containerId, inventory, PlanetsMenuProvider.createDisabledPlanetsFromBuf(buf), PlanetsMenuProvider.createSpaceStationsFromBuf(buf), PlanetsMenuProvider.createClaimedChunksFromBuf(buf), PlanetsMenuProvider.createSpawnLocationsFromBuf(buf));
    }

    public PlanetsMenu(int containerId, Inventory inventory, Set<ResourceLocation> disabledPlanets, Map<ResourceKey<Level>, Map<UUID, Set<SpaceStation>>> spaceStations, Object2BooleanMap<ResourceKey<Level>> claimedChunks, Set<GlobalPos> spawnLocations) {
        super((MenuType)ModMenus.PLANETS.get(), containerId);
        int n;
        this.inventory = inventory;
        this.player = inventory.f_35978_;
        this.level = this.player.m_9236_();
        Entity entity = this.player.m_20202_();
        if (entity instanceof Rocket) {
            Rocket vehicle = (Rocket)entity;
            n = vehicle.tier();
        } else {
            n = 100;
        }
        this.tier = n;
        this.disabledPlanets = disabledPlanets;
        this.spaceStations = spaceStations;
        this.ingredients = this.getSpaceStationRecipes();
        this.spawnLocations = spawnLocations;
        this.claimedChunks.putAll(claimedChunks);
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public int tier() {
        return this.tier;
    }

    public Player player() {
        return this.player;
    }

    public Set<ResourceLocation> disabledPlanets() {
        return this.disabledPlanets;
    }

    public Map<ResourceKey<Level>, List<Pair<ItemStack, Integer>>> ingredients() {
        return this.ingredients;
    }

    public boolean isClaimed(ResourceKey<Level> dimension) {
        return this.claimedChunks.getBoolean(dimension);
    }

    public boolean canConstruct(ResourceKey<Level> dimension) {
        if (this.isClaimed(dimension)) {
            return false;
        }
        SpaceStationRecipe recipe = SpaceStationRecipe.getSpaceStation(this.level, dimension).orElse(null);
        if (recipe == null) {
            return false;
        }
        return SpaceStationRecipe.hasIngredients(this.player, this.level, recipe);
    }

    private Map<ResourceKey<Level>, List<Pair<ItemStack, Integer>>> getSpaceStationRecipes() {
        List spaceStationRecipes = this.level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.SPACE_STATION_RECIPE.get());
        HashMap<ResourceKey<Level>, List<Pair<ItemStack, Integer>>> recipes = new HashMap<ResourceKey<Level>, List<Pair<ItemStack, Integer>>>(spaceStationRecipes.size());
        for (SpaceStationRecipe recipe : spaceStationRecipes) {
            for (IngredientHolder holder : recipe.ingredients()) {
                int count = 0;
                for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                    ItemStack stack = this.inventory.m_8020_(i);
                    if (!holder.ingredient().test(stack)) continue;
                    count += stack.m_41613_();
                }
                recipes.computeIfAbsent(recipe.dimension(), k -> new ArrayList()).add(new Pair((Object)holder.ingredient().m_43908_()[0].m_255036_(holder.count()), (Object)count));
            }
        }
        return recipes;
    }

    public boolean isInSpaceStation(ResourceKey<Level> dimension) {
        ChunkPos pos = this.player.m_146902_();
        Map<UUID, Set<SpaceStation>> allStations = this.spaceStations.get(dimension);
        if (allStations == null) {
            return false;
        }
        for (Set<SpaceStation> stations : allStations.values()) {
            for (SpaceStation station : stations) {
                if (station.position().m_45594_(pos) > 2) continue;
                return true;
            }
        }
        return false;
    }

    public List<Pair<String, SpaceStation>> getOwnedSpaceStations(ResourceKey<Level> dimension, GameProfile player) {
        Map<UUID, Set<SpaceStation>> allStations = this.spaceStations.get(dimension);
        if (allStations == null) {
            return List.of();
        }
        Set<SpaceStation> stations = allStations.get(player.getId());
        if (stations == null) {
            return List.of();
        }
        return stations.stream().sorted(Comparator.comparing(station -> station.name().getString())).map(station -> new Pair((Object)player.getName(), station)).toList();
    }

    public List<Pair<String, SpaceStation>> getOwnedAndTeamSpaceStations(ResourceKey<Level> dimension) {
        ArrayList<Pair<String, SpaceStation>> stations = new ArrayList<Pair<String, SpaceStation>>(this.getOwnedSpaceStations(dimension, this.player.m_36316_()));
        if (!ArgonautsIntegration.argonautsLoaded()) {
            return stations;
        }
        for (GameProfile member : ArgonautsIntegration.getClientPartyMembers(this.player.m_20148_())) {
            if (member.equals((Object)this.player.m_36316_())) continue;
            stations.addAll(this.getOwnedSpaceStations(dimension, member));
        }
        for (GameProfile member : ArgonautsIntegration.getClientGuildMembers(this.player.m_20148_())) {
            if (member.equals((Object)this.player.m_36316_())) continue;
            stations.addAll(this.getOwnedSpaceStations(dimension, member));
        }
        return stations;
    }

    public void constructSpaceStation(ResourceKey<Level> dimension, Component name) {
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundConstructSpaceStationPacket(dimension, name));
    }

    public BlockPos getLandingPos(ResourceKey<Level> dimension, boolean tryPreviousLocation) {
        boolean landingNormally;
        boolean bl = landingNormally = tryPreviousLocation && this.player.m_20202_() instanceof Rocket;
        if (!landingNormally) {
            this.player.m_20183_();
        }
        for (GlobalPos pos : this.spawnLocations) {
            if (!pos.m_122640_().equals(dimension)) continue;
            return pos.m_122646_();
        }
        return this.player.m_20183_();
    }

    public Component getPlanetName(ResourceKey<Level> dimension) {
        return Component.m_264568_((String)"planet.%s.%s".formatted(dimension.m_135782_().m_135827_(), dimension.m_135782_().m_135815_()), (String)PlanetsScreen.title(dimension.m_135782_().m_135815_()));
    }

    public List<Planet> getSortedPlanets() {
        return AdAstraData.planets().values().stream().filter(planet -> !this.disabledPlanets().contains(planet.dimension().m_135782_())).filter(planet -> this.tier() >= planet.tier()).sorted(Comparator.comparingInt(Planet::tier).thenComparing(p -> this.getPlanetName(p.dimension()).getString())).toList();
    }
}

