/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class WorldUtils {
    private WorldUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    @Nullable
    @Contract(value="_, null, _, _ -> null")
    public static <A extends BlockEntity> A getTileEntity(Class<A> clazz, @Nullable Level reader, BlockPos pos, boolean logWrongType) {
        BlockEntity tile = WorldUtils.getTileEntity(reader, pos);
        if (tile == null) {
            return null;
        }
        if (clazz.isInstance(tile)) {
            return (A)((BlockEntity)clazz.cast(tile));
        }
        if (logWrongType) {
            Constants.LOGGER.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", new Object[]{pos, clazz, tile.getClass()});
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static BlockEntity getTileEntity(@Nullable Level world, BlockPos pos) {
        return !WorldUtils.isBlockLoaded(world, pos) ? null : world.m_7702_(pos);
    }

    @Contract(value="null, _ -> false")
    public static boolean isBlockLoaded(@Nullable Level world, BlockPos pos) {
        return world != null && world.m_46739_(pos) && world.m_46749_(pos);
    }

    @Nullable
    @Contract(value="_, null, _ -> null")
    public static <T extends BlockEntity> T getTileEntity(Class<T> clazz, @Nullable Level world, BlockPos pos) {
        return WorldUtils.getTileEntity(clazz, world, pos, false);
    }
}

